;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                      ;
; COMMANDS that can be invoked in the SUB-EVAL loop.          ;
;                                                                      ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define menu
"
   Sub-Eval commands: enter (without parens or quotes)
   at the `SUB-EVAL==>' prompt and execute with C-x C-e.
   (See file Guide.doc for further help.)

exit-sm | quit-sm            Exit the SUB-EVAL loop safely
help-sm                      Show this help menu
load-sm-file                 prompts for file of expressions to SUB-EVAL
import-code                  prompts for file of Scheme definitions to
                                install as SUB-EVAL system-constants
show-global-bindings         Display global bindings
verbose                      Show all steps
concise                      Show `interesting' steps (the default)
verbtog                      Toggle Verbose/Concise mode
rule-names-on                Show name of rule applied
rule-names-off
reinit-globals               Reinitializes environments and counters
")

(define (interface-command? exp)
  (memq exp '(exit-sm quit-sm
              help-sm
              load-sm-file import-code
              show-global-bindings
              verbose concise verbtog
              rule-names-on rules-names-off
              reinit-globals)))

(define (dispatch-interface-command exp)
  (case exp
    ((exit-sm quit-sm) (set! exit-loop-flag #t) undefined-value)
    ((help-sm) (newline) (display menu) undefined-value)
    ((load-sm-file) (load-sm-file) undefined-value)
    ((import-code) (import-code) undefined-value)
    ((show-global-bindings) (pp the-global-environment) undefined-value)
    ((verbose) (verbose-on) undefined-value)
    ((concise) (verbose-off) undefined-value)
    ((verbtog) (verbtog) undefined-value)
    ((rule-names-on) (rule-names-on) undefined-value)
    ((rule-names-off) (rule-names-off) undefined-value)
    ((reinit-globals) (reinitialize) undefined-value)))

(define exit-loop-flag #f)

(define (import-code)
  (newline)
  (display "Enter filename within double quotes: ")
  (install-system-defs (read)))

(define (load-sm-file)
  (newline)
  (display "Enter filename within double quotes: ")
  (load-user-sm-file (read)))

(define verbose #f)

(define (verbtog)                         ;REVISE end proc name with !
  (if verbose
      (verbose-off)
      (verbose-on)))

(define (verbose-on)                         ;REVISE end proc name with !
  (newline)
  (display "Setting to Verbose mode")
  (newline)
  (set! verbose #t))

(define (verbose-off)                         ;REVISE end proc name with !
  (newline)
  (display "Setting to Concise mode")
  (newline)
  (set! verbose #f))


                           ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
                           ;;;                        ;;;
                           ;;;     TRACING RULES      ;;;
                           ;;; (As yet unimplemented) ;;;
                           ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; GLOBAL FLAGS FOR RULES:

;(define trace-beta-redex #f)

;(define trace-let-gc #f)

;(define trace-letrec-gc #f)

;(define trace-let-apply #f)

;(define trace-letrec-apply #f)

;(define trace-if #f)

;(define trace-cond #f)

;(define trace-or #f)

;(define trace-and #f)

;(define trace-scheme-eval #f)

(define (rule-names-on)
  (newline)
  (display "Recording rule-names")
  (newline)
  (set! show-rule-names #t))

(define (rule-names-off)
  (newline)
  (display "Rule-names will not be recorded")
  (newline)
  (set! show-rule-names #f))

(define (reinitialize)
  (set! exit-loop-flag #f)
  (set! display-variable #t)
  (set! line-count 0)
  (set! record-of-steps '())
  (set! variable-name '())
  (set! numbered-variable-list '())
  (set! system-constant-suffix 0)
  (set! the-global-environment (copy init-the-global-environment))
  (set! functional-constants (copy init-functional-constants))
  (set! side-effect-constants (copy init-side-effect-constants))
  (set! show-rule-names #t)
  (set! verbose #f))
