;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                      ;
; COMMANDS that can be invoked in the SUB-EVAL loop.          ;
;                                                                      ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define menu
"
   Sub-Eval commands: enter (without parens or quotes)
   at the `SUB-EVAL==>' prompt and execute with C-x C-e.
   (See file Guide.doc for further help.)

exit-sm | quit-sm            Exit the SUB-EVAL loop safely
help-sm                      Show this help menu
load-sm-file                 prompts for file of expressions to SUB-EVAL
import-code                  prompts for file of Scheme definitions to
                                install as SUB-EVAL system-constants
show-global-bindings         Display global bindings
verbose                      Show all steps
concise                      Show `interesting' steps (the default)
verbtog                      Toggle Verbose/Concise mode
rule-names-on                Show name of rule applied
rule-names-off
listops-scheme               Use Scheme's list operations--fast but hides steps
listops-sm                   Use SUB-EVAL'S list operations (the default)
listopstog
mapsteptog                   Display steps of map application, toggle (default: on)
")

(define (interface-command? exp)
  (memq exp '(exit-sm quit-sm
              help-sm
              load-sm-file import-code
              show-global-bindings
              verbose concise verbtog
              rule-names-on rules-names-off
              listops-scheme listops-sm listopstog
              mapsteptog)))

(define (dispatch-interface-command exp)
  (case exp
    ((exit-sm quit-sm) (exit-sub-eval-loop) undefined-value)
    ((help-sm) (newline) (display menu))
    ((load-sm-file) (load-sm-file) undefined-value)
    ((import-code) (import-code) undefined-value)
    ((show-global-bindings) (pp the-global-environment) undefined-value)
    ((verbose) (verbose-on) undefined-value)
    ((concise) (verbose-off) undefined-value)
    ((verbtog) (verbtog) undefined-value)
    ((rule-names-on) (rule-names-on) undefined-value)
    ((rule-names-off) (rule-names-off) undefined-value)
    ((listops-scheme) (listops-scheme) undefined-value)
    ((listops-sm) (listops-sm) undefined-value)
    ((listopstog) (toggle-scheme-listops) undefined-value)
    ((mapsteptog) (toggle-op-display '<<map>>) undefined-value)))
  
(define (exit-sub-eval-loop)
  (set! exit-loop-flag #t))

(define exit-loop-flag #f)

(define (toggle-op-display op-symbol)
  (newline)
  (let ((op-assoc (assoc op-symbol expand-assocs)))
    (if op-assoc
        (display (string-append
                  "Applications of "
                  (symbol->string op-symbol)
                  " will NOT be expanded"))
        (display (string-append
                  "Applications of "
                  (symbol->string op-symbol)
                  " WILL be expanded")))
    (set-cdr! op-assoc (not (cdr op-assoc)))
    (newline)))

(define expand-assocs
  '((<<null?>>     #f)
    (<<append>>    #f)
    (<<delete>>    #f)
    (<<reverse>>   #f)
    (<<list- ref>> #f)
    (<<list-tail>> #f)
    (<<map>>       #t)))
;; REVISE: add <<member>>

(define (expand-op? op-symbol)
  (let ((flag-binding (assoc op-symbol expand-assocs)))
    (if flag-binding
        (cadr flag-binding)
        (sm-error "Expand unknown op: " op-symbol))))

(define scheme-listops #f)

(define (toggle-scheme-listops)         ;REVISE end proc name with !
  (if scheme-listops
      (listops-sm)
      (listops-scheme)))

(define (listops-scheme)                ;REVISE end proc name with !
  (newline)
  (set! scheme-listops #t)
  (display "Now using SCHEME list operators")
  (newline))

(define (listops-sm)                    ;REVISE end proc name with !
  (newline)
  (set! scheme-listops #f)
  (display "Now using SUB-EVAL list operations")
  (newline))
      
(define (import-code)
  (newline)
  (display "Enter filename within double quotes: ")
  (install-system-defs (read)))

(define (load-sm-file)
  (newline)
  (display "Enter filename within double quotes: ")
  (load-user-sm-file (read)))

(define verbose #f)

(define (verbtog)                         ;REVISE end proc name with !
  (if verbose
      (verbose-off)
      (verbose-on)))

(define (verbose-on)                         ;REVISE end proc name with !
  (newline)
  (display "Setting to Verbose mode")
  (newline)
  (set! verbose #t))

(define (verbose-off)                         ;REVISE end proc name with !
  (newline)
  (display "Setting to Concise mode")
  (newline)
  (set! verbose #f))


                           ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
                           ;;;                        ;;;
                           ;;;     TRACING RULES      ;;;
                           ;;; (As yet unimplemented) ;;;
                           ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; GLOBAL FLAGS FOR RULES:

;(define trace-beta-redex #f)

;(define trace-let-gc #f)

;(define trace-letrec-gc #f)

;(define trace-let-apply #f)

;(define trace-letrec-apply #f)

;(define trace-if #f)

;(define trace-cond #f)

;(define trace-or #f)

;(define trace-and #f)

;(define trace-scheme-eval #f)

(define (rule-names-on)
  (newline)
  (display "Recording rule-names")
  (newline)
  (set! show-rule-names #t))

(define (rule-names-off)
  (newline)
  (display "Rule-names will not be recorded")
  (newline)
  (set! show-rule-names #f))
