// cl_alloca().

#ifndef _CL_ALLOCA_H
#define _CL_ALLOCA_H

#include "cl_macros.h"

// Allocating temporary data of arbitrary size on the stack.
// Usage:
//   {CL_ALLOCA_STACK
//    ...
//    ... = cl_alloca(...);
//    ...
//    ... = cl_alloca(...);
//    ...
//   }
// CL_ALLOCA_STACK declares that use of cl_alloca() is possible.
// Then cl_alloca() can be used an arbitrary number of times to get room.
// The allocated room's extent ends at the end of the { ... } block.
// In every C function CL_ALLOCA_STACK should only called once.
// Because of a gcc bug, functions using these macros shouldn't be declared
// inline.

#if defined(__GNUC__) && !defined(__riscos) && !defined(__convex__)
  #define CL_ALLOCA_STACK
  #define cl_alloca __builtin_alloca
#elif !defined(NO_ALLOCA) && !defined(SPARC)
  #define CL_ALLOCA_STACK
  #define cl_alloca alloca
#else
  #include "cl_malloca.h"
  // Save a malloca()/freea() "stack" pointer,
  // restore it automatically when the block or the function is exited.
  class cl_alloca_stack {
	void* pointer;
  public:
	cl_alloca_stack () { pointer = cl_malloca_getstack(); }
	~cl_alloca_stack () { cl_malloca_setstack(pointer); }
  };
  #define CL_ALLOCA_STACK cl_alloca_stack CONCAT(cl_alloca_stack_,__LINE__);
  #define cl_alloca cl_malloca
#endif

#endif /* _CL_ALLOCA_H */
