/*****************************************************************************
**
**    nq.h                            NQ                       Werner Nickel
**                                                    werner@pell.anu.edu.au
**
**    Copyright Dec 1992                        Mathematics Research Section
**                                           School of Mathematical Sciences 
**                                            Australian National University
*/

/*
**    This include file contains the declarations of data structures that
**    build a polycyclic presentation.
*/

#include <stdio.h>

/*
**    This variable indicates whether GAP output should be produced.
*/
extern	int	Gap;

/*
**    This variable switches the verbose mode on.
*/
extern	int	Verbose;

#include "genexp.h"
#include "pc.h"
#include "pcarith.h"
#include "collect.h"
#include "macro.h"

extern int	*Dimension;

extern word	*Generators;

/*
**    The data structures used for the integer triagonalization.
*/
extern	long     NrRows;
extern	long     NrCols;
extern	long	*Heads;

/*
**    Functions manipulating words.
**    Defined in word.c.
*/
extern	word	getWord();
extern	int	cmpWords();
extern	void	printWord();

/*
**    Functions manipulating exponent vectors
*/
extern	expvec	expVector();

/*
**    The collection routines, defined in collect.c.
*/
extern	int	Collect();
extern	word	Solve();
extern	word	Invert();

/*
**    Functions manipulating the pc-presentation,
**    defined in pc.c.
*/
extern	void	initPcPres();
extern	void	readPcPres();
extern	void	calcCommute();
extern	void	completePcPres();

/*
**    Some useful functions defined in system.c.
*/
extern	long	RunTime();

/*
**    Print functions.
*/
extern	void	printList();
extern	void	printExpVec();

/*
**    The consistency check.
*/
extern	void	consistency();

extern	void	NqRelations();
