/* version numbers */
#include <stdio.h>
#include <stddef.h>
#include "patchlev.h"

typedef struct {
	char *module_name;
	char *version_number;
} VERSION;

VERSION version_list[] = {
	{"aut.c","7.7"},
	{"pc.c","3.4"},
	{"conju.c","2.8"},
	{"error.c","4.8"},
	{"farith.c","1.6"},
	{"gl.c","2.0"},
	{"grpring.c","2.0"},
	{"hgroup.c","1.0"},
	{"inout.c","3.7"},
	{"lcontrol.c","6.8"},
	{"lie.c","1.9"},
	{"matrix.c","1.8"},
	{"obslif.c","5.3"},
	{"obstruct.c","3.5"},
	{"parsesup.c","2.8"},
	{"sisgram.y","5.3"},
	{"sisscan.l","3.5"},
	{"solve.c","3.5"},
	{"space.c","2.1"},
	{"storage.c","4.0"},
	{"lex.yy.c","3.5"},
	{"aobstruc.c","3.5"},
};

void show_version ( void )
{
	size_t num_moduls, i;
	
	num_moduls = sizeof version_list / sizeof ( VERSION );
	
	for ( i = 0; i < num_moduls; i++ )
		printf ( "module %13s : %5s\n", version_list[i].module_name,
			version_list[i].version_number );
	printf ( "\nglobal version number : %s\n", global_version );
}

/* end of module version */
