/****************************************************************************
**
*A  utils.h                     XGAP Source                      Frank Celler
**
*H  @(#)$Id: utils.h,v 1.1 1993/10/18 11:04:47 fceller Exp $
**
*Y  Copyright 1993-1995,   Frank Celler,   Lehrstuhl D fuer Mathematik,  RWTH
**
*H  $Log: utils.h,v $
*H  Revision 1.1  1993/10/18  11:04:47  fceller
*H  added fast updated,  fixed timing problem
*H
*H  Revision 1.0  1993/04/05  11:42:18  fceller
*H  Initial revision
*H
*/
#ifndef _utils_h
#define _utils_h


/****************************************************************************
**
*M  P(( <arg> ))  . . . . . . . . . . . . . . . . . . . . . . . .  prototypes
*/
#ifndef P
#  ifdef  __STDC__
#    define P(ARGS) ARGS
#  else
#    define P(ARGS) ()
#  endif
#endif


/****************************************************************************
**

*T  TypeList  . . . . . . . . . . . . . . . . . . . . . . . .  list structure
*/
typedef struct _list
{
    long        size;
    long        len;
    void     ** ptr;
}
* TypeList;


/****************************************************************************
**
*F  List( <len> )   . . . . . . . . . . . . . . . . . . .   create a new list
*/
#if defined(X11_MALLOC_DEBUG_ON)
extern TypeList FClist P((char *,  int,  int ));
#define List(a)	FClist( __FILE__, __LINE__, (a) )
#else
extern TypeList List P(( int ));
#endif


/****************************************************************************
**
*F  AddList( <lst>, <elm> ) . . . . . . . .  add list element <elm> to <list>
*/
extern void AddList P(( TypeList, void * ));


/****************************************************************************
**

*M  DEBUG(( <str> ))  . . . . . . . . . . . . . . . print <str> as debug info
*/
#ifdef  DEBUG_ON
extern int Debug;
#define	DEBUG(a) {if(Debug){printf("%04d:%s: ",__LINE__,__FILE__);printf a;}}
#else
#define DEBUG(a) /* no debug */
#endif


/****************************************************************************
**
*D  MALLOC_DEBUG_ON . . . . . . . . . . . . . . . . . . . . . malloc debugger
*/
#if !defined(_utils_c) && defined(MALLOC_DEBUG_ON)

/* C malloc functions */
#define malloc(a) 	FCmalloc ( __FILE__, __LINE__, (a) )
#define free(a)         FCfree   ( __FILE__, __LINE__, (a) )
#define realloc(a,b)    FCrealloc( __FILE__, __LINE__, (a), (b) )

/* prototypes */
void * FCmalloc         P(( char *,  int,  size_t ));
void   FCfree           P(( char *,  int,  void * ));
void * FCrealloc        P(( char *,  int,  void *,  size_t ));

#endif


/****************************************************************************
**
*D  X11_MALLOC_DEBUG_ON	. . . . . . . . . . . . . . . . . X11 malloc debugger
*/
#if !defined(_utils_c) && defined(X11_MALLOC_DEBUG_ON)

/* X11 malloc functions */
#define XtMalloc(a)     FCxtmalloc ( __FILE__, __LINE__, (a) )
#define XtFree(a)       FCxtfree   ( __FILE__, __LINE__, (a) )
#define XtRealloc(a,b)  FCxtrealloc( __FILE__, __LINE__, (a), (b) )

/* prototypes */
void * FCxtmalloc       P(( char *,  int,  size_t ));
void   FCxtfree         P(( char *,  int,  void * ));
void * FCxtrealloc      P(( char *,  int,  void *,  size_t ));

#endif


/****************************************************************************
**
*F  FCmalloc_check_free() . . . . . . . . . . . . . . . . . . . . check frees
*/
#if defined(MALLOC_DEBUG_ON) || defined(X11_MALLOC_DEBUG_ON)
void   FCmalloc_check_free      P(( void ));
#else
#ifndef _utils_c
#define FCmalloc_check_free()   do ; while (0)
#endif
#endif


/****************************************************************************
**

*M  MAX( <a>, <b> ) . . . . . . . . . . . . . . . . .  maximum of <a> and <b>
*/
#undef  MAX
#define	MAX(a,b)	(((a) < (b)) ? (b) : (a))


/****************************************************************************
**
*M  MIN( <a>, <b> ) . . . . . . . . . . . . . . . . .  minimum of <a> and <b>
*/
#undef  MIN
#define	MIN(a,b)	(((a) < (b)) ? (a) : (b))

#endif
