/****************************************************************************
**
*A  polynom.h                    GAP source                      Frank Celler
**
*A  @(#)$Id: polynom.h,v 3.4 1993/03/01 10:33:13 fceller Rel $
**
*Y  Copyright 1990-1992,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
**
*H  $Log: polynom.h,v $
*H  Revision 3.4  1993/03/01  10:33:13  fceller
*H  adapted to new list concept
*H
*H  Revision 3.3  1992/11/25  11:29:30  fceller
*H  added prototypes
*H
*H  Revision 3.2  1992/05/25  08:56:08  fceller
*H  Initial GAP 3.2 release
*/


/****************************************************************************
**
*F  UnifiedFieldVecFFE( <hdL>, <hdR> )	. . . unify fields of <hdL> and <hdR>
**
**  Convert two finite field vectors into finite field vectors over  the same
**  finite field.  Signal an error if this conversion fails.
*/
extern TypHandle UnifiedFieldVecFFE P(( TypHandle, TypHandle ));


/****************************************************************************
**
*F  NormalizeCoeffs( <hdC>, <c> ) . . . . . . . . . . . resize & retype <hdC>
*/
extern TypHandle NormalizeCoeffs P(( TypHandle, long ));


/****************************************************************************
**
*F  AddVecFFE( <hdL>, <l>, <hdR>, <r>, <m> )  . . . . . . . . . poly addition
**
**  Add <m>-times the (finite field) coefficient vector <hdR>  to the (finite
**  field) coefficient vector <hdL>.  The  degree plus one of  the  result is
**  returned. Note that we will enlarge <hdL> if necessary, but we will *not*
**  shrink the vector, if if the degree of the result is less than <l>.
**
** long AddVecFFE P(( TypHandle, long, TypHandle, long, TypFFE ));
*/
extern long AddVecFFE ();


/****************************************************************************
**
*F  AddVector( <hdL>, <l>, <hdR>, <r>, <m> )  . . . . . . . . . poly addition
**
**  Add  <m>-times  the coefficient vector  <hdR>  to  the coefficient vector
**  <hdL>.  The degree plus one  of  the  result is  returned.  Note that  we
**  will enlarge <hdL> if necessary, but we will *not* shrink the vector,  if
**  if the degree of the result is less than <l>.
*/
extern long AddVector P(( TypHandle, long, TypHandle, long, TypHandle ));


/****************************************************************************
**
*F  FunSumCoeffs( <hdCall> )  . . . . . . . . . internal function 'SumCoeffs'
**
**  'FunSumCoeffs' implements 'SumCoeffs( <l>, <r> )'
*/
extern TypHandle FunSumCoeffs P(( TypHandle ));


/****************************************************************************
**
*F  FunAddCoeffs( <hdCall> )  . . . . . . . . . internal function 'AddCoeffs'
**
**  'FunAddCoeffs' implements 'AddCoeffs( <l>, <r> )'
*/
extern TypHandle FunAddCoeffs P(( TypHandle ));


/****************************************************************************
**
*F  MultiplyVecFFE( <hdP>, <hdL>, <l>, <hdR>, <r> ) . . . poly multiplication
**
**  Multiply   two (finite field)  coefficient vectors  <hdL>   and <hdR> and
**  store the  result in  <hdP>.  <l>  (<r>)  gives the   degree plus  one of
**  <hdL> (<hdR>), the  result  must have  degree  <l>+<r>-2 because   we are
**  working over a field. The degree plus one of the result is returned.
*/
extern long MultiplyVecFFE P((TypHandle,TypHandle,long,TypHandle,long));


/****************************************************************************
**
*F  MultiplyVector( <hdP>, <hdL>, <l>, <hdR>, <r> ) . . . poly multiplication
**
**  Multiply two   (rational,   cyclotomic)  coefficient vectors   <hdL>  and
**  <hdR>  and store the result  in <hdP>.  <l> (<r>)  gives the degree  plus
**  one  of   <hdL> (<hdR>),  the result  must  have degree <l>+<r>-2 because
**  we are working  over   a field. The  degree  plus  one  of  the result is
**  returned.
*/
extern long MultiplyVector P((TypHandle,TypHandle,long,TypHandle,long));


/****************************************************************************
**
*F  FunProductCoeffs( <hdCall> )  . . . . . internal function 'ProductCoeffs'
**
**  'FunProductCoeffs' implements 'ProductCoeffs( <l>, <r> )'
*/
extern TypHandle FunProductCoeffs P(( TypHandle ));


/****************************************************************************
**
*F  ReduceVecFFE( <hdL>, <l>, <hdR>, <r> )  . . . . . reduce polynomial <hdL>
**
**  Reduce   the  polynomial  <hdL> in place  by  the   polynomial <hdR>.  <l>
**  (<r>)  must be  the degree  plus 1 of  <hdL> (<hdR>). The degree plus one
**  of the result is returned.
*/
extern long ReduceVecFFE P(( TypHandle, long, TypHandle, long ));


/****************************************************************************
**
*F  ReduceVector( <hdL>, <l>, <hdR>, <r> )  . . . . . reduce polynomial <hdL>
**
**  Reduce   the  polynomial  <hdL> in place  by  the   polynomial <hdR>.  <l>
**  (<r>)  must be  the degree  plus 1 of  <hdL> (<hdR>). The degree plus one
**  of the result is returned.
*/
extern long ReduceVector P(( TypHandle, long, TypHandle, long ));


/****************************************************************************
**
*F  FunRemainderCoeffs( <hdCall> )  . . . internal function 'RemainderCoeffs'
**
**  'FunRemainderCoeffs' implements 'RemainderCoeffs( <l>, <r> )'
*/
extern TypHandle FunRemainderCoeffs P(( TypHandle ));


/****************************************************************************
**
*F  FunReduceCoeffs( <hdCall> ) . . . . . .  internal function 'ReduceCoeffs'
**
**  'FunReduceCoeffs' implements 'ReduceCoeffs( <l>, <r> )'
*/
extern TypHandle FunReduceCoeffs P(( TypHandle ));


/****************************************************************************
**
*F  PowerModVecInt( <hdG>, <g>, <exp>, <hdF>, <f> ) . . . power mod small int
*/
extern TypHandle PowerModVecInt P((TypHandle, long, long, TypHandle, long));


/****************************************************************************
**
*F  PowerModVecLongInt( <hdG>, <g>, <hdE>, <hdF>, <f> ) .  power mod long int
*/
extern TypHandle PowerModVecLongInt P(( TypHandle,
				        long,
				        TypHandle,
				        TypHandle, 
				        long ));


/****************************************************************************
**
*F  FunPowerModCoeffs( <hdCall> ) . . . .  internal function 'PowerModCoeffs'
*/
extern TypHandle FunPowerModCoeffs P(( TypHandle ));


/****************************************************************************
**
*F  FunShiftedCoeffs( <hdCall> )  . . . . . internal function 'ShiftedCoeffs'
**
**  'FunShiftedCoeffs' implements 'ShiftedCoeffs( <l>, <n> )'
*/
extern TypHandle FunShiftedCoeffs P(( TypHandle ));


/****************************************************************************
**
*F  InitPolynom() . . . . . . . . . . . . . .  initialize the polynom package
*/
extern void InitPolynom P(( void ));


/****************************************************************************
**
*E  Emacs . . . . . . . . . . . . . . . . . . . . . . . local emacs variables
**
**  Local Variables:
**  mode:               outline
**  outline-regexp:     "*F\\|*V\\|*T\\|*E"
**  fill-column:        77
**  fill-prefix:        "**  "
**  eval:               (local-set-key "\t" 'c-indent-command)
**  eval:               (local-set-key ";"  'electric-c-semi )
**  eval:               (local-set-key "{"  'electric-c-brace)
**  eval:               (local-set-key "}"  'electric-c-brace)
**  eval:               (hide-body)
**  End:
*/
