;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald DEDUCTION-GRAPHS)



; Contents: 1. sequent & inference nodes
;	    2. deduction-graphs
; 
; bidirectional nodes now removed.  
  
(define-structure-type SEQUENT-NODE
  graph							;in which node sits
  out-arrows						;towards inferences it's a hyp for
  in-arrows						;from inferences it's the conc of
  grounded?						;'#t iff grounded in graph
  level							; how many rungs from immediately grounded nodes
  sequent						;heart of the node
  hidden?						;'#t instructs printer
							;not to show this node
  number						;index of node in its graph

  (((print self port)
    (format port "#{IMPS-sqn ~S}" (if (use-sequent-node-numbers?)
				      (sequent-node-number self)
				      (object-hash self))))))

(block
  (set (sequent-node-out-arrows (stype-master sequent-node-stype)) nil)
  (set (sequent-node-in-arrows (stype-master sequent-node-stype)) nil)
  (set (sequent-node-grounded? (stype-master sequent-node-stype)) '#f)
  (set (sequent-node-level (stype-master sequent-node-stype)) '#f)
  (set (sequent-node-graph (stype-master sequent-node-stype)) '#f)
  (set (sequent-node-hidden? (stype-master sequent-node-stype)) '#f)
  (set (sequent-node-number (stype-master sequent-node-stype)) '#f))

(define (SEQUENT->SEQUENT-NODE sequent)
  (let ((node (make-sequent-node)))
    (set (sequent-node-sequent node) sequent)
    node))

(define (SEQUENT-NODE-ADD-ARROW node direction partner)
  (case direction
    ((in)  (push (sequent-node-in-arrows node) partner))
    ((out) (push (sequent-node-out-arrows node) partner))
    (else  (imps-error "SEQUENT-NODE-ADD-ARROW: bad direction ~S" direction))))

;;; (define (SEQUENT-NODE-ADD-ARROW node direction partner)
;;;   (case direction
;;;     ((in) (set (sequent-node-in-arrows node)
;;; 	       (append! (sequent-node-in-arrows node) (list partner))))
;;;     ((out) (set (sequent-node-out-arrows node)
;;; 		(append! (sequent-node-out-arrows node) (list partner))))
;;;     (else (imps-error "SEQUENT-NODE-ADD-ARROW: bad direction ~S" direction))))

(define (SEQUENT-NODE-ASSUMPTIONS sqn)
  (context-assumptions (sequent-context (sequent-node-sequent sqn))))

(define (SEQUENT-NODE-CONTEXT sqn)
  (sequent-context (sequent-node-sequent sqn)))

(define SEQUENT-NODE-ASSERTION
  (operation
      (lambda (sqn)
	(sequent-assertion (sequent-node-sequent sqn)))
    ((setter self)
     (lambda (sqn new-assertion)
       (imps-enforce formula? new-assertion)
       (set (sequent-assertion (sequent-node-sequent sqn))
	    new-assertion)))))

(define (SEQUENT-NODE->STRING sqn)
  (let ((assumptions (sequent-node-assumptions sqn))
	(assertion (sequent-node-assertion sqn)))
    (format nil
	    "~A~%~%  =>~%~%~A"
	    (assumptions->string assumptions)
	    (qp assertion))))

(define (SEQUENT-NODE->SEXP sqn)
  (let ((assertion (sequent-node-assertion sqn))
	(assumption-sexp (assumptions->sexp (sequent-node-assumptions sqn))))
    (if (list? assumption-sexp)
	(append
	 assumption-sexp
	 (list '=> (expression->sexp assertion)))
	(list assumption-sexp '=> (expression->sexp assertion)))))

(define (SEQUENT-NODE-HIDE sqn)
  (set (sequent-node-hidden? sqn) '#t)
  sqn)

(define (SEQUENT-NODE-HIDE-SUPPORT sqn)
  ;;this hides a node and everything below it.
  (sequent-node-hide sqn)
  (if (not (null? (sequent-node-in-arrows sqn)))
      (walk (lambda (inf)
	      (walk (lambda (sq) (sequent-node-hide-support sq))
		    (inference-node-hypotheses inf)))
	    (sequent-node-in-arrows sqn)))
  sqn)
  
(define (SEQUENT-NODE-UNHIDE sqn)
  (set (sequent-node-hidden? sqn) '#f)
  sqn)

(define-structure-type INFERENCE
  rule							;to infer conc from hyps
  name					                ;name
  hypotheses						;list of SEQUENTS
  conclusion						;SEQUENT
  context-simplification-persistence			;integer, ambient value
							;when inference created
  

  (((print self port)
    (format port "#{IMPS-inference~_~S}" (object-hash self)))
   ((name self)	(inference-name self))))

(define (BUILD-INFERENCE rule hyps conc)
  (let ((inf (make-inference)))
    (set (inference-rule inf) rule)
    (set (inference-name inf) (name rule))
    (set (inference-hypotheses inf) hyps)
    (set (inference-conclusion inf) conc)
    (set (inference-context-simplification-persistence inf)
	 (context-simplification-persistence))
    inf))
  
(define (INFERENCE-EQUAL? inf1 inf2)
  (and
   (eq? (inference-rule inf1) (inference-rule inf2))
   (eq? (inference-conclusion inf1) (inference-conclusion inf2))
   (equal? (inference-hypotheses inf1) (inference-hypotheses inf2))))

(define-structure-type INFERENCE-NODE
  graph							;of which it is a part
  grounded?						;'#t iff grounded in graph
  level							; how many rungs from immediately grounded nodes
  inference						;used to create this node
  hypotheses						;list of sequent NODES
  conclusion						;sequent NODE

  (((print self port)
    (format port "#{IMPS-inference-node~_~S}" (object-hash self)))))

(define (INFERENCE-NODE->SYMBOL infn)
  (let ((n (name (inference-node-inference infn))))
    (or n 'anonymous-inference)))

(block
  (set (inference-node-grounded? (stype-master inference-node-stype)) '#f)
  (set (inference-node-level (stype-master inference-node-stype)) '#f)
  (set (inference-node-graph (stype-master inference-node-stype)) '#f))

(define (BUILD-INFERENCE-NODE inference hyp-nodes conc-node)
  (let ((node (make-inference-node)))
    (set (inference-node-inference node) inference)
    (set (inference-node-hypotheses node) hyp-nodes)
    (set (inference-node-conclusion node) conc-node)
    (if (= (length hyp-nodes) 0)
	(block (set (inference-node-grounded? node) '#t)
	       (set (inference-node-level node) 0)))
    node))

(define (inference-node-major-premises inf)
  (let ((rule (inference-rule (inference-node-inference inf)))
	(hyps (inference-node-hypotheses inf)))
    (rule-major-premises-proc rule hyps)))

(define (SUCCEED-WITHOUT-GROUNDING? inf)
  (and (succeed? inf)
       (not (immediately-grounded? (deduction-graph-goal (inference-node-graph inf))))
       (not (null? (inference-node-hypotheses inf)))))


(define (INFERENCE-NODE-1ST-HYPOTHESIS inf)
  (car (inference-node-hypotheses inf)))

(define (INFERENCE-NODE-2ND-HYPOTHESIS inf)
 (cadr (inference-node-hypotheses inf)))

(define-constant major-premise inference-node-1st-hypothesis)

(define (NODE-GRAPH node)
  ((if (sequent-node? node)				;get right accessor
       sequent-node-graph				;and apply it
       inference-node-graph)				;to node
   node))

(define (sequent-node-parent sqn)
  (iterate iter ((infns (sequent-node-out-arrows sqn)))
    (if (null? infns)
	(maybe-imps-error "sequent-node-parent: not hypothesis to any non-trivial inference: ~S"
		    sqn)
	(let ((conc (inference-node-conclusion (car infns))))
	  (if (eq? conc sqn)
	      (iter (cdr infns))
	      conc)))))

(define (sequent-node-first-satisfactory-child pred sqn)
  (let ((infns (sequent-node-in-arrows sqn)))
    (if (null? infns)
	(maybe-imps-error "sequent-node-first-satisfactory-child: No support for ~S" sqn)
	(or (any
	     (lambda (infn)
	       (any (lambda (sqn)
		      (and (pred sqn)
			   sqn))
		    (inference-node-hypotheses infn)))
	     infns)
	    (maybe-imps-error "sequent-node-first-satisfactory-child: No satisfactory child")))))

(define (sequent-node-first-child sqn)
  (sequent-node-first-satisfactory-child (always '#t) sqn))

(define (sequent-node-siblings sqn)
  (let ((infn (car (sequent-node-out-arrows sqn))))
    (if (inference-node? infn)
	(inference-node-hypotheses infn)
	(maybe-imps-error "sequent-node-siblings: not hypothesis to any inference: ~S"
		    sqn))))

(define (sequent-node-first-satisfactory-sibling pred sqn)
  (let ((infn (car (sequent-node-out-arrows sqn))))
    (or (any (lambda (sqn)
	       (and (pred sqn)
		    sqn))
	     (inference-node-hypotheses infn))
	(maybe-imps-error "sequent-node-first-satisfactory-sibling: No satisfactory sibling"))))

(define (sequent-node-first-sibling sqn)
  (car (sequent-node-siblings sqn)))

(define (sequent-node-next-sibling sqn)
  (let ((val (cadr (memq sqn (sequent-node-siblings sqn)))))
    (if (null? val)
	(maybe-imps-error "sequent-node-next-sibling: no more siblings: ~S"
		    sqn)
	val)))

(define (sequent-node-first-ungrounded-sibling sqn)
  (sequent-node-first-satisfactory-sibling
   (lambda (sqn)
     (not (sequent-node-grounded? sqn)))
   sqn))

(define (sequent-node-first-new-descendent last-index-before sqn)
  (bind (((imps-raise-error?) '#f))
    (let ((first (sequent-node-first-unsupported-descendent sqn)))
      (and (sequent-node? first)
	   (< last-index-before (sequent-node-number first))
	   first))))

(define-structure-type DEDUCTION-GRAPH
  goal							;to be proved in graph
  sequent-nodes						;in the graph
  inference-nodes					;in the graph
  immediately-grounded					;set of inference-nodes sans hyps
  theory						;relative to which this is a dg
  foci							;push-down list of nodes
  history						;push-down list of d.g. operation calls
  ;;sqn-history                                           ;list recording largest sequent node numbers
  ;;unsupported-sqns                                      ;list recording unsupported nodes.
  last-index						;most recently used sequent node number
  
  ;;computation-nodes					;in the graph
  ;;last-cmpn-index					;most recently used cmpn number
  unended-block-count					;"begins" unmatched by "ends"

  (((print self port)
    (format port "#{IMPS-deduction-graph~_~S}" (object-hash self)))))

(block
  (set (deduction-graph-goal (stype-master deduction-graph-stype)) '#f)
  (set (deduction-graph-sequent-nodes (stype-master deduction-graph-stype)) nil)
  (set (deduction-graph-inference-nodes (stype-master deduction-graph-stype)) nil)
  (set (deduction-graph-immediately-grounded (stype-master deduction-graph-stype)) nil)
  (set (deduction-graph-theory (stype-master deduction-graph-stype)) nil)
  (set (deduction-graph-foci (stype-master deduction-graph-stype)) nil)
  (set (deduction-graph-history (stype-master deduction-graph-stype)) nil)
  ;;(set (deduction-graph-sqn-history (stype-master deduction-graph-stype)) '())
  ;;(set (deduction-graph-unsupported-sqns (stype-master deduction-graph-stype)) '())
  (set (deduction-graph-last-index (stype-master deduction-graph-stype)) 0)
  ;;(set (deduction-graph-computation-nodes (stype-master deduction-graph-stype)) nil)
  ;;(set (deduction-graph-last-cmpn-index (stype-master deduction-graph-stype)) 0)
  (set (deduction-graph-unended-block-count (stype-master deduction-graph-stype)) 0))

(define (deduction-graph-nodes dg)
  (append (deduction-graph-sequent-nodes dg)
	  (deduction-graph-inference-nodes dg)))

(define (dg-add-sequent-node-internal dg sqn)
  (set (deduction-graph-sequent-nodes dg)
       (append (deduction-graph-sequent-nodes dg) (list sqn))))

(define (dg-add-inference-node-internal dg infn)
  (set (deduction-graph-inference-nodes dg)
       (append (deduction-graph-inference-nodes dg) (list infn))))

(lset *DGS* nil)					;global list of deduction graphs

(define CURRENT-DG
  (let ((the-dg nil))
    (object
	(lambda ()
	  (or the-dg
	      (and *dgs*
		   (block
		     (set the-dg (car *dgs*))
		     the-dg))))
      ((setter self) (lambda (nv) (set the-dg nv))))))

(define (SET-CURRENT-DG DG)
  (set (current-dg) dg))

(define (RESET-CURRENT-DG)
  (set (current-dg) (car *dgs*)))

(define (DISCARD-OLD-DGS)
  (set (cdr *dgs*) nil))

(define (dg-register-node sym sqn)
  (let ((dg (sequent-node-graph sqn)))
    (cond ((assq sym (deduction-graph-foci dg))
	   => (lambda (p) (set (cdr p) sqn)))
	  (else
	   (push (deduction-graph-foci dg) (cons sym sqn))))))

(define (dg-get-registered-node dg sym)
  (cond ((assq sym (deduction-graph-foci dg)) => cdr)
	(else '#f)))

'((define (FOCUS dg)
    (if (null? (deduction-graph-foci dg))
	'#f
	(let ((first (car (deduction-graph-foci dg))))
	  (if (immediately-grounded? first)
	      (block
		(pop-focus dg)
		(focus dg))
	      first))))

  (define (POP-FOCUS dg)
    (if (null? (deduction-graph-foci dg))
	'#f
	(pop (deduction-graph-foci dg))))

  (define (push-focus dg sqn)
    (push (deduction-graph-foci dg) sqn))

  (define (replace-focus dg sqn)
    (pop-focus dg)
    (push-focus dg sqn)))

(define-structure-type DG-HISTORY-ENTRY
  graph
  command
  sequent-node
  arguments
  previous-entry
  nodes-grounded
  last-index-before
  last-index-after
  jump-from-previous-expectation
  first-unsupported-relative
  annotation-before
  annotation-after
  comments)

(define (BUILD-AND-POST-DG-HISTORY-ENTRY
	 graph command sqn arguments last-index-before jump-from-previous comments)
  (let ((struct (make-dg-history-entry))
	(previous-entry (car (deduction-graph-history graph))))


;;;    (set (dg-history-entry-sexp-form struct)
;;;	 (append (list command sqn arguments) comments))

    (set (dg-history-entry-graph struct) graph)
    (set (dg-history-entry-command struct) command)
    (set (dg-history-entry-sequent-node struct) sqn)
    (set (dg-history-entry-arguments struct) arguments)
    (set (dg-history-entry-previous-entry struct) previous-entry)
    (set (dg-history-entry-nodes-grounded struct) (immediately-grounded-nodes graph))
    (set (dg-history-entry-last-index-before struct) last-index-before)
    (set (dg-history-entry-last-index-after struct) (deduction-graph-last-index graph))
    (set (deduction-graph-history graph)
	 (cons struct (deduction-graph-history graph)))
    (set  (dg-history-entry-jump-from-previous-expectation struct) jump-from-previous)
    (set  (dg-history-entry-annotation-before struct) '())
    (set  (dg-history-entry-annotation-after struct) '())

    (set  (dg-history-entry-comments struct) comments)
    
    (if
     (not (immediately-grounded? (deduction-graph-goal graph)))
     (bind (((imps-raise-error?) '#f))
       (set (dg-history-entry-first-unsupported-relative struct)
	    (sequent-node-first-unsupported-relative sqn)))
     (set (dg-history-entry-first-unsupported-relative struct) '#f))
	   
    struct))

(define use-verbose-sequent-nodes?
  (make-simple-switch 'use-verbose-sequent-nodes? boolean? '#t))


;;;(define (build-executable-form obj)
;;;  (cond ((null? obj) (list 'quote obj))
;;;	((string? obj) (list 'quote obj))
;;;	((number? obj) (list 'quote obj))
;;;	((symbol? obj) (list 'quote obj))
;;;	((proper-list? obj)
;;;	 `(list ,@(map build-executable-form obj)))
;;;	((macete? obj) `(name->macete ',(name obj)))
;;;	((sequent-node? obj)
;;;	 (if (use-verbose-sequent-nodes?)
;;;	     `(read-sequent-and-post
;;;	       ,(assumptions->string (sequent-node-assumptions obj))
;;;	       ,(qp (sequent-node-assertion obj))
;;;	       (current-dg))
;;;	     `(sequent-unhash-currently ,(sequent-node-number obj))))
;;;	((expression? obj) `(qr ,(qp obj)))
;;;	((dg-command? obj) `(name->command ',(name obj)))
;;;	((inductor? obj) `(name->inductor ',(name obj)))
;;;	(else (imps-error "BUILD-EXECUTABLE-FORM: weird object ~A" obj))))

(define (dg-history-entry-previous-last-index-after entry)
  (let ((previous (dg-history-entry-previous-entry entry)))
    (if (null? previous)
	0
	(dg-history-entry-last-index-after previous))))

(define (dg-history-entry-nodes-grounded-by-command entry)
  (set-diff (dg-history-entry-nodes-grounded entry)
	    (dg-history-entry-previous-nodes-grounded entry)))

(define (dg-history-entry-previous-nodes-grounded entry)
  (let ((previous (dg-history-entry-previous-entry entry)))
    (if (null? previous)
	'()
	(dg-history-entry-nodes-grounded previous))))

(define (dg-history-entry-added-nodes entry)
  (- (dg-history-entry-last-index-after entry)
     (dg-history-entry-last-index-before entry)))

(define (dg-history-entry-new-nodes entry)
  (let ((before (dg-history-entry-last-index-before entry))
	(after (dg-history-entry-last-index-after entry)))
    (iterate loop ((before (1+ before)) (accum '()))
      (if (< after before)
	  (let ((sqns '()))
	    (if (null? accum)
		accum
		(walk (lambda (x) (if (mem? = (sequent-node-number x) accum)
					       (push sqns x)))
			       (deduction-graph-sequent-nodes (dg-history-entry-graph entry))))
	    (reverse sqns))

	  (loop (1+ before) (cons before accum))))))

(define (dg-history-entry-postings-after-last-entry entry)
  (let ((last (dg-history-entry-previous-last-index-after entry))
	(before (dg-history-entry-last-index-before  entry)))
    (iterate loop ((last (1+ last)) (accum '()))
      (if (< before last)
	  (let ((sqns '()))
	    (if (null? accum)
		accum
		(walk (lambda (x) (if (mem? = (sequent-node-number x) accum)
				      (push sqns x)))
		      (deduction-graph-sequent-nodes (dg-history-entry-graph entry))))
	    sqns)
	  (loop (1+ last) (cons last accum))))))

(define (dg-history-entry-superfluous? entry)
  (and (= 0 (dg-history-entry-added-nodes entry))
       (null? (filter-list sequent-node? (dg-history-entry-nodes-grounded-by-command entry)))))


(define (dg-history-entry-sequent-nodes-grounded-by-command entry)
  (filter-list sequent-node? (dg-history-entry-nodes-grounded-by-command entry)))

;;;(define (DEDUCTION-GRAPH-ADD-TO-HISTORY dg string-or-sexp))
;;;  (set (deduction-graph-sqn-history dg)
;;;       (append-item-to-last-cdr! (deduction-graph-sqn-history dg)
;;;				 (deduction-graph-last-index dg)))
;;;  (set (deduction-graph-unsupported-sqns dg)
;;;       (append-item-to-last-cdr!
;;;	(deduction-graph-unsupported-sqns dg)
;;;	(let ((unsup '()))
;;;	  (walk (lambda (x) (if (unsupported? x) (push unsup (sequent-node-number x))))
;;;		(deduction-graph-sequent-nodes dg))
;;;	  unsup)))
;;;  (set (deduction-graph-history dg)
;;;       (append-item-to-last-cdr! (deduction-graph-history dg) string-or-sexp))
;;;

;;;(define (deduction-graph-executable-initialization dg)
;;;  (let ((goal-assumption-string (assumptions->string (sequent-node-assumptions (deduction-graph-goal dg))))
;;;	(goal-assertion-string (qp (sequent-node-assertion (deduction-graph-goal dg)))))
;;;;;	(theory-name (theory-name (deduction-graph-theory dg)))
;;;    `(read-sequent-and-start-emacs-deduction
;;;      ,goal-assumption-string
;;;      ,goal-assertion-string 
;;;      1)))

;;;(define (dg-history-entry-executable-form e)
;;;  `(deduction-graph-apply-command
;;;    ,(build-executable-form (dg-history-entry-command e))
;;;    (list ,(build-executable-form (dg-history-entry-sequent-node e)))
;;;    ,(build-executable-form (dg-history-entry-arguments e))
;;;    ,(build-executable-form (dg-history-entry-comments e))))

(define (deduction-graph-save-history dg file)
  (with-open-ports ((p (open file '(out))))
    (walk 
     (lambda (x) (newline p) (pretty-print x p))
     (deduction-graph-readable-history-list dg))
    '#t))
;;;
;;;      (let ((history (reverse (deduction-graph-history dg))))
;;;
;;;	(pretty-print `(clear-em) p)
;;;	(format p "~%~%")
;;;	(pretty-print `(set (current-theory) (name->theory ',(name (deduction-graph-theory dg))))  p)
;;;	(format p "~%~%")
;;;	(pretty-print (deduction-graph-executable-initialization dg) p)
;;;      
;;;	(walk (lambda (e)
;;;		(format p "~%~%")
;;;		(pretty-print (dg-history-entry-executable-form e) p))
;;;	  
;;;	      history)))))

(define (DEDUCTION-GRAPH-LOCATE-SEQUENT deduction-graph seq)
  (any
   (lambda (sqn)
     (and (sequents-alpha-equivalent? (sequent-node-sequent sqn) seq)
	  sqn))
   (deduction-graph-sequent-nodes deduction-graph)))

(define (DEDUCTION-GRAPH-ADD-SEQUENT-NODE deduction-graph sqn)
  (cond ((and (sequent-node-graph sqn)
	      (not (eq? deduction-graph (sequent-node-graph sqn))))
	 (imps-error "DEDUCTION-GRAPH-ADD-SEQUENT-NODE: Cannot add ~S~_to ~S~_-- already belongs to ~S."
		sqn deduction-graph (sequent-node-graph sqn)))
	((memq? sqn (deduction-graph-sequent-nodes deduction-graph))
	 sqn)
	(else (set (sequent-node-graph sqn) deduction-graph)
	      (set (sequent-node-number sqn)
		   (increment (deduction-graph-last-index deduction-graph)))
	      (if (sequent-entailment-flag (sequent-node-sequent sqn))
		  (set (sequent-node-grounded? sqn) '#t))
	      (dg-add-sequent-node-internal deduction-graph sqn)
	      sqn)))

(define (POST formula-or-sequent dg)
  (let ((seq
	 (cond ((sequent? formula-or-sequent)
		(if (theory? (deduction-graph-theory dg))
		    (sequent->theory-sequent (deduction-graph-theory dg)
					     formula-or-sequent)
		    formula-or-sequent))
	       ((formula? formula-or-sequent)
		(theory-assertion->sequent (deduction-graph-theory dg)
					   formula-or-sequent))
	       (else (imps-error "POST: bad arg ~S~_neither formula nor sequent"
				 formula-or-sequent)))))
    (cond ((not (deduction-graph-goal dg))
	   (let ((sqn (sequent->sequent-node seq)))
	     (deduction-graph-add-sequent-node dg sqn)
	     (set (deduction-graph-goal dg) sqn)
	     sqn))
	  ((deduction-graph-locate-sequent dg seq)
	   =>
	   (lambda (sqn)
	     (sequent-node-unhide sqn)
	     sqn))
	  (else      
	   (let ((sqn (sequent->sequent-node seq)))
	     (deduction-graph-add-sequent-node dg sqn)
	     sqn)))))

(comment

 (define-structure-type COMPUTATION-NODE
   graph				;in which node sits
   context				;in which expressions are manipulated 
   expressions				;to be manipulated
   sqns					;(plural) from which it was derived 
   number				;index of node in its graph

   (((print self port)
     (format port "#{IMPS-cmpn ~S}"
	     (computation-node-number self)))))

 (define (computation-node-add-expressions cmpn exprs)
   (modify (computation-node-expressions cmpn)
	   (lambda (already)
	     (set-union exprs already)))
   cmpn)

 (define (add-computation-node sqn dg)
   (let ((context (sequent-node-context sqn))
	 (exprs   (initial-cmpn-expressions (sequent-node-assertion sqn))))
     (let ((cmpn (make-computation-node)))
       (set (computation-node-graph cmpn) dg)
       (set (computation-node-context cmpn) context)
       (set (computation-node-expressions cmpn) exprs)
       (set (computation-node-sqns cmpn) (list sqn))
       (set (computation-node-number cmpn) (increment (deduction-graph-last-cmpn-index dg)))
       (push (deduction-graph-computation-nodes dg) cmpn)
       cmpn)))
	 
 (define (post-computation-node sqn)
   (let ((dg (sequent-node-graph sqn)))
     (cond ((let ((context (sequent-node-context sqn)))
	      (any
	       (lambda (cmpn)
		 (and (eq? context (computation-node-context cmpn))
		      cmpn))
	       (deduction-graph-computation-nodes dg)))
	    =>
	    (lambda (cmpn)
	      (modify (computation-node-sqns cmpn)
		      (lambda (sqns)
			(add-set-element sqn sqns)))
	      (computation-node-add-expressions
	       cmpn
	       (initial-cmpn-expressions (sequent-node-assertion sqn)))))
	   (else (add-computation-node sqn dg)))))

 (define (initial-cmpn-expressions assertion)
   (list assertion))

 (define (partition-computation-node cmpn)
   (let ((context (computation-node-context cmpn)))
     (partition-set
      (computation-node-expressions cmpn)
      (lambda (e1 e2)
	(context-exprs-quasi-equal? context e1 e2)))))

 (define (deduction-graph-find-cmpn dg cmpn-index)
   (any
    (lambda (cmpn)
      (and (= cmpn-index (computation-node-number cmpn))
	   cmpn))
    (deduction-graph-computation-nodes dg)))

 )

(define (START-DEDUCTION goal theory)			
  ;goal a seq
  (let ((dg (make-deduction-graph)))
    (set (deduction-graph-theory dg) theory)
    (if goal
	(set (deduction-graph-goal dg)			;goal node created 
	     (post goal dg)))				;by post
    (push *dgs* dg)
    (reset-current-dg)
    dg))

(define (DEDUCTION-GRAPH-ADD-SEQUENT-NODES-FOR-INFERENCE dg hyps conc)
  (let ((make-node
	 (lambda (seq)					;create or retrieve as needed 
	   (post seq dg))))
    (return
     (map make-node hyps)
     (make-node conc))))

(define (INFERENCE->INFERENCE-NODE inference  dg)
  (or
   (deduction-graph-seek-inference dg inference)	;maybe already there
   (receive (hyp-nodes conc-node)
     (deduction-graph-add-sequent-nodes-for-inference	;else add sequent nodes 
      dg
      (inference-hypotheses inference)
      (inference-conclusion inference))
     (build-inference-node inference			;inference node contains 
			   hyp-nodes			;sequent nodes 
			   conc-node))))

(define (DEDUCTION-GRAPH-SEEK-INFERENCE dg inference)
  (any
   (lambda (infn)					;walk through checking with 
     (and (inference-equal? inference			;inference-equal?
			    (inference-node-inference infn))
	  infn))
   (deduction-graph-inference-nodes dg)))

(define (DEDUCTION-GRAPH-ADD-INFERENCE-NODE dg infn)
  (if (and (inference-node-graph infn)
	   (not (eq? dg (inference-node-graph infn))))
      (imps-error "DEDUCTION-GRAPH-ADD-INFERENCE-NODE: Cannot add ~S~_to ~S~_-- already belongs to ~S."
		  sqn dg (inference-node-graph infn)))
  (or (memq? infn (deduction-graph-inference-nodes dg))	;already there?
      (block
	(set (inference-node-graph infn) dg) ;otherwise add it
	(dg-add-inference-node-internal dg infn)
	(if (immediately-grounded? infn) ;immediately grounded?
	    (push (deduction-graph-immediately-grounded dg)
		  infn)) 
	(sequent-node-add-arrow		;update conclusion in-arrows
	 (inference-node-conclusion infn) 'in infn)
	(walk (lambda (hn)		;and hyp out arrows
		(sequent-node-add-arrow hn 'out infn))
	      (inference-node-hypotheses infn)))) ;grounding info
  infn)

(define (IMMEDIATELY-GROUNDED? node)
  (if (inference-node? node)
      (and (or (inference-node-grounded? node)
	       (null? (inference-node-hypotheses node))) ;will already have level 0
	   (block (set (inference-node-grounded? node) '#t)
		  '#t))
      ;; else sequent-node...
      (cond ((any?
	      immediately-grounded?
	      (sequent-node-in-arrows node))
	     (set (sequent-node-grounded? node) '#t)
	     (if (not (number? (sequent-node-level node)))
		 (set (sequent-node-level node) 0))
	     (make-sequent-entailed (sequent-node-sequent node))
	     '#t)
	    ((sequent-node-grounded? node) ;should already have level
	     (make-sequent-entailed (sequent-node-sequent node))
	     '#t)
	    ((sequent-entailment-flag (sequent-node-sequent node))
	     (set (sequent-node-grounded? node) '#t)
	     (if (not (number? (sequent-node-level node)))
		 (set (sequent-node-level node) 0))
	     '#t)
	    (else '#f))))

(define (IMMEDIATELY-GROUNDED-NODES dg)
  (set-separate
   immediately-grounded?
   (deduction-graph-nodes dg)))

(define (POST-INFERENCE inference  dg)
  (let ((infn (deduction-graph-add-inference-node
	       dg
	       (inference->inference-node inference dg))))
    (update-grounding dg)
    infn))

(lset *list-details-for-grounded-nodes* '#f)

;;;

(define xdg?
  (make-simple-switch 'xdg? boolean? '#f))

(define (print-dg dg port)
  (labels
      
      (((print-sqn first offset remaining)
	(if (or (not (sequent-node? first))
		(sequent-node-hidden? first))
	    (delete-set-element first remaining)
	    (block
	      (writec port #\( )
	      (cond ((and (xdg?)
			  (sequent-node-grounded? first)
			  (not *list-details-for-grounded-nodes*))
		     (format port "\"Sequent ~D: GROUNDED\")" (sequent-node-number first)))
		    ((xdg?)
		     (print (sequent-node-number first) port))
		    ((and (sequent-node-grounded? first)
			  (not *list-details-for-grounded-nodes*))
		     (print first port)
		     (writes port " GROUNDED)"))
		    (else (print first port)))
	      (cond ((and (sequent-node-grounded? first)
			  (not *list-details-for-grounded-nodes*))
		     (delete-set-element first remaining))
		    ((not (memq? first remaining))
		     (writes port " -see above-)")
		     remaining)
		    (else
		     (let ((new-offset (1+ offset))
			   (infns (sequent-node-in-arrows first)))
		       (iterate iter ((remaining remaining)
				      (infns infns))
			 (cond ((null? infns)
				(writec port #\) )
				(delete-set-element first remaining))
			       (else
				(iter
				 (print-infn (car infns) new-offset
					     (delete-set-element first remaining))
				 (cdr infns)))))))))))

       ((print-infn infn offset remaining)
	(fresh-line port)
	(set (hpos port) offset)
	(writec port #\( )
	(print (inference-node->symbol infn) port)
	(let ((offset (1+ offset))
	      (hyps (inference-node-hypotheses infn)))
	  (iterate iter ((hyps hyps)
			 (remaining remaining))
	    (if (null? hyps)
		(block (writec port #\) )
		       remaining)
		(iter
		 (cdr hyps)
		 (block (fresh-line port)
			(set (hpos port) offset)
			(print-sqn (car hyps) offset remaining)))))))

       ((main remaining)
	(if (null? remaining)
	    (block (writec port #\) )
		   repl-wont-print)
	    (main (block (fresh-line port)
			 (set (hpos port) 1)
			 (print-sqn (car remaining) 1 remaining))))))

    (if (xdg?)
	(writes port "(show-deduction-graph "))
    (writec port #\( )
    (let ((remaining (if *list-details-for-grounded-nodes*
			 (deduction-graph-sequent-nodes dg)
			 (set-separate
			  (lambda (sqn) (not (sequent-node-grounded? sqn)))
			  (deduction-graph-sequent-nodes dg)))))
      (main
       (print-sqn (deduction-graph-goal dg) 1 remaining)))
    (if (xdg?)
	(writes port ")"))))

(define (DISCARD-GROUNDING dg)
  (walk
   (lambda (infn)
     (set (inference-node-grounded? infn) '#f))
   (deduction-graph-inference-nodes dg))
    (walk
     (lambda (sqn)
       (set (sequent-node-grounded? sqn) '#f))
     (deduction-graph-sequent-nodes dg)))

(comment

 This is an improved version --- if we can get it to work.
 formerly had a simpler action on sequent nodes, as it did not
 check if the sequent was trivially entailed.

 (define (UPDATE-GROUNDING dg)
   (labels
    (((MAIN previously-ungrounded-sqns previously-ungrounded-infns)
      (let ((ungrounded-sqns
	     (set-separate
	      (lambda (sqn)
		(not (sequent-node-grounded? sqn)))
	      previously-ungrounded-sqns))
	    (ungrounded-infns
	     (set-separate
	      (lambda (infn)
		(not (inference-node-grounded? infn)))
	      previously-ungrounded-infns)))
	(ground-some-sqns ungrounded-sqns ungrounded-infns)))

     ((GROUND-SOME-SQNS ungrounded-sqns ungrounded-infns)
      (iterate iter ((sqns ungrounded-sqns)
		     (continue? '#f))
	       (if (null? sqns)
		   (ground-some-infns ungrounded-sqns ungrounded-infns continue?)
		 (let ((sqn (car sqns)))
		   (cond
		    ((any? inference-node-grounded? (sequent-node-in-arrows sqn))
		     (set (sequent-node-grounded? sqn) '#t)
		     (make-sequent-entailed (sequent-node-sequent sqn))
		     (set (sequent-node-level sqn)
			  (inference-node-level
			   (any
			    (lambda (infn)
			      (and (inference-node-grounded? infn)
				   infn))
			    (sequent-node-in-arrows sqn))))
		     (iter (cdr sqns) '#t))
		    ((let ((context (sequent-node-context sqn))
			   (assertion (sequent-node-assertion sqn)))
		       (context-trivially-entails? context assertion))
		     (set (sequent-node-grounded? sqn) '#t)
		     (make-sequent-entailed (sequent-node-sequent sqn))
		     (set (sequent-node-level sqn) 0)
		     (iter (cdr sqns) '#t))
		    (else (iter (cdr sqns) continue?)))))))

     ((GROUND-SOME-INFNS ungrounded-sqns ungrounded-infns continue?)
      (iterate iter ((infns ungrounded-infns)
		     (continue? continue?))
	       (cond ((and (null? infns)
			   continue?)
		      (main ungrounded-sqns ungrounded-infns))
		     ((null? infns)
		      (return))
		     (else
		      (let ((infn (car infns)))
			(if (every?
			     sequent-node-grounded?
			     (inference-node-hypotheses infn))
			    (block
			     (set (inference-node-grounded? infn) '#t)
			     (set (inference-node-level infn)
				  (1+
				   (iterate iter ((hyps (inference-node-hypotheses infn))
						  (lvl 0))
					    (cond ((null? hyps) lvl)
						  ((and (number? (sequent-node-level (car hyps)))
							(< lvl (sequent-node-level (car hyps))))
						   (iter (cdr hyps)
							 (sequent-node-level (car hyps))))
						  (else (iter (cdr hyps) lvl))))))
			     (iter (cdr infns) '#t))
			  (iter (cdr infns) continue?))))))))

    (main (set-separate
	   (lambda (sqn)
	     (not (immediately-grounded? sqn)))
	   (deduction-graph-sequent-nodes dg))
	  (set-separate
	   (lambda (sqn)
	     (not (immediately-grounded? sqn)))
	   (deduction-graph-inference-nodes dg)))))

 )

(define (UPDATE-GROUNDING dg)
  (labels
   (((MAIN previously-ungrounded-sqns previously-ungrounded-infns)
     (let ((ungrounded-sqns
	    (set-separate
	     (lambda (sqn)
	       (not (sequent-node-grounded? sqn)))
	     previously-ungrounded-sqns))
	   (ungrounded-infns
	    (set-separate
	     (lambda (infn)
	       (not (inference-node-grounded? infn)))
	     previously-ungrounded-infns)))
       (ground-some-sqns ungrounded-sqns ungrounded-infns)))

    ((GROUND-SOME-SQNS ungrounded-sqns ungrounded-infns)
     (iterate iter ((sqns ungrounded-sqns)
		    (continue? '#f))
	      (if (null? sqns)
		  (ground-some-infns ungrounded-sqns ungrounded-infns continue?)
		(let ((sqn (car sqns)))
		  (if (any?
		       inference-node-grounded?
		       (sequent-node-in-arrows sqn))
		      (block
		       (set (sequent-node-grounded? sqn) '#t)
		       (make-sequent-entailed (sequent-node-sequent sqn))
		       (set (sequent-node-level sqn)
			    (inference-node-level
			     (any
			      (lambda (infn)
				(and (inference-node-grounded? infn)
				     infn))
			      (sequent-node-in-arrows sqn))))
		       (iter (cdr sqns) '#t))
		    (iter (cdr sqns) continue?))))))

    ((GROUND-SOME-INFNS ungrounded-sqns ungrounded-infns continue?)
     (iterate iter ((infns ungrounded-infns)
		    (continue? continue?))
	      (cond ((and (null? infns)
			  continue?)
		     (main ungrounded-sqns ungrounded-infns))
		    ((null? infns)
		     (return))
		    (else
		     (let ((infn (car infns)))
		       (if (every?
			    sequent-node-grounded?
			    (inference-node-hypotheses infn))
			   (block
			    (set (inference-node-grounded? infn) '#t)
			    (set (inference-node-level infn)
				 (1+
				  (iterate iter ((hyps (inference-node-hypotheses infn))
						 (lvl 0))
					   (cond ((null? hyps) lvl)
						 ((and (number? (sequent-node-level (car hyps)))
						       (< lvl (sequent-node-level (car hyps))))
						  (iter (cdr hyps)
							(sequent-node-level (car hyps))))
						 (else (iter (cdr hyps) lvl))))))
			    (iter (cdr infns) '#t))
			 (iter (cdr infns) continue?))))))))

   (main (set-separate
	  (lambda (sqn)
	    (not (immediately-grounded? sqn)))
	  (deduction-graph-sequent-nodes dg))
	 (set-separate
	  (lambda (sqn)
	    (not (immediately-grounded? sqn)))
	  (deduction-graph-inference-nodes dg)))))



(define (OLD-UPDATE-GROUNDING dg)
  (labels
      (((choose-candidate candidates to-examine)	;select candidate to examine 
	(if (null? candidates)				;and then loop or exit.
	    (or (null? to-examine)
		(choose-candidate to-examine nil))
	    (choose-candidate
	     (cdr candidates)
	     (examine-candidate (car candidates) to-examine))))

       ((examine-candidate candidate to-examine)	; examine candidate and return 
	(if (or (inference-node-grounded? candidate)	; extended set of to-examine-ees 
		(any?
		 (lambda (sqn) (not (sequent-node-grounded? sqn)))
		 (inference-node-hypotheses candidate)))
	    to-examine					;can't add to-examinees
	    (set-union
	     (block					;ground candidate and look at conc
	       (set (inference-node-grounded? candidate) '#t)
	       (ground-and-collect-to-examines candidate))
	     to-examine)))

       ((ground-and-collect-to-examines candidate)	; ground the conclusion sqn and return
	(let ((sqn					; infns on its out-arrows	   
	       (inference-node-conclusion candidate)))
	  (and (not (sequent-node-grounded? sqn))
	       (block
		 (make-sequent-entailed (sequent-node-sequent sqn)) 
		 (set (sequent-node-grounded? sqn) '#t)
		 (sequent-node-out-arrows sqn))))))

    (choose-candidate (immediately-grounded-nodes dg) nil)))

(define (UNSUPPORTED? sqn)
  (null? (sequent-node-in-arrows sqn)))

(define (DEDUCTION-GRAPH-UNSUPPORTED-NODES dg)
  (set-separate unsupported? (deduction-graph-sequent-nodes dg)))

(define (DEDUCTION-GRAPH-UNHIDDEN-NODES dg)
  (set-separate (lambda (x) (not (sequent-node-hidden? x)))
		(deduction-graph-sequent-nodes dg)))

(define (DEDUCTION-GRAPH-UNSUPPORTED-UNHIDDEN-NODES dg)
  (set-separate (lambda (x) (not (sequent-node-hidden? x)))
		(deduction-graph-unsupported-nodes dg)))

(define (DEDUCTION-GRAPH-GROUNDED-SQNS dg)
  (set-separate sequent-node-grounded? (deduction-graph-sequent-nodes dg)))

(define (DEDUCTION-GRAPH-GROUNDED? dg)
  (cond ((deduction-graph-goal dg)
	 => sequent-node-grounded?)
	(else
	 (null? (deduction-graph-unsupported-nodes dg)))))

;;; The operation ->RULE coerces a rule into a procedure which if
;;; applied to a list of sequents (and '#fs) returns either an inference
;;; extending the list or else FAIL.  It is used by all the follwing routines for
;;; extending deduction-graphs.   

(define (DEDUCTION-GRAPH-INFER rule sqns dg)
  (let ((real-rule (->rule rule)))
    (if (not ((rule-soundness-predicate real-rule)
	      (deduction-graph-theory dg)))
	(fail)
	(let ((inf (real-rule
		    (map (lambda (sqn) (and (sequent-node? sqn)
					    (sequent-node-sequent sqn)))
			 sqns))))
	  (if (inference? inf)
	      (post-inference inf dg)
	      (fail))))))

(define (DEDUCTION-GRAPH-APPLY-RULE rule sqns)
  (let ((dg (any
	     (lambda (sqn)
	       (and (sequent-node? sqn)
		    (sequent-node-graph sqn)))
	     sqns)))
    (if (not (deduction-graph? dg))
	(imps-error "DEDUCTION-GRAPH-APPLY-RULE: need at least one real sqn.~_~S"
		    sqns))
    (deduction-graph-infer rule sqns dg)))


(define (DEDUCTION-GRAPH-GOAL-FORMULA? dg formula)
  (let ((goal-sequent (sequent-node-sequent (deduction-graph-goal dg))))
    (and (null? (sequent-assumptions goal-sequent))
	 (alpha-equivalent? formula (sequent-assertion goal-sequent)))))


