;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald numerical-objects)

(define NUMERICAL-OBJECT? (operation number?))
(define-operation (NUMERICAL-= x y)
  (cond ((and (number? x)
	      (number? y))
	 (= x y))
	((number? x)
	 (numerical-= y x))
	(else
	 (error "numerical-=: bogus args ~s ~s" x y))))

(define NUMERICAL-+  (operation +))
(define NUMERICAL-*  (operation *))
(define NUMERICAL-EXPT  (operation expt))
(define NUMERICAL-MINUS (operation -))
(define NUMERICAL-=0? (operation =0?))
(define NUMERICAL-=1? (operation (lambda (a) (= a 1))))
(define NUMERICAL-> (operation >))
(define NUMERICAL-< (operation
			(lambda (x y)(numerical-> y x))))

;;; Eventually there will be several number types around.

(define-structure-type NUMERICAL-TYPE
  
  coercion-function         ;;;A PARTIAL procedure of 1 argument from integers with values in numerical-type. For values on which it is defined, must be a homorphism.
 
  recognizer                ;;;a predicate which is true iff object is of type.

  identifier                ;;;some symbol for printing the type.

  (((print soi port) (format port "~a" (numerical-type-identifier soi)))))
  
(define (COERCE-TYPE type num)
  (enforce number? num)
  (enforce numerical-type? type)
  ((numerical-type-coercion-function type) num))

;;;(define BASIC-NUMBER-TYPE 
;;;  (let ((new-type (make-numerical-type)))
;;;    (set (numerical-type-coercion-function new-type)
;;;	 (lambda (n) (enforce number? n) n))
;;;    (set (numerical-type-recognizer new-type) number?)
;;;    (set (numerical-type-identifier new-type) 'number)
;;;    new-type))

(lset *non-negative-integer-type*
  (let ((new-type (make-numerical-type)))
    (set (numerical-type-coercion-function new-type)
	 (lambda (n) (if (non-negative-integer? n) n '#f)))
    (set (numerical-type-recognizer new-type) non-negative-integer?)
    (set (numerical-type-identifier new-type) 'non-negative-integer)
    new-type))

(lset *integer-type*
  (let ((new-type (make-numerical-type)))
    (set (numerical-type-coercion-function new-type)
	 (lambda (n) (if (integer? n) n '#f)))
    (set (numerical-type-recognizer new-type) integer?)
    (set (numerical-type-identifier new-type) 'integer)
    new-type))

(lset *rational-type*
  (let ((new-type (make-numerical-type)))
    (set (numerical-type-coercion-function new-type)
	 (lambda (n) (if (rational? n) n '#f)))
    (set (numerical-type-recognizer new-type) rational?)
    (set (numerical-type-identifier new-type) 'rational)
    new-type))

(lset *float-type*
  (let ((new-type (make-numerical-type)))
    (set (numerical-type-coercion-function new-type)
	 (lambda (n) (if (float? n) n '#f)))
    (set (numerical-type-recognizer new-type) float?)
    (set (numerical-type-identifier new-type) 'float)
    new-type))

(lset *number-type*
  (let ((new-type (make-numerical-type)))
    (set (numerical-type-coercion-function new-type)
	 (lambda (n) (if (number? n) n '#f)))
    (set (numerical-type-recognizer new-type) number?)
    (set (numerical-type-identifier new-type) 'number)
    new-type))


(lset *integer-extension-types* (list *integer-type* *rational-type*))

(define (INTEGER-EXTENSION-TYPE? type)
  (enforce numerical-type? type)
  (memq? type *integer-extension-types*))


(define-operation (NUMERICAL-TYPE x))

;;;This checks whether all args have the same numerical type.

(define (CHECK-NUMERICAL-TYPES . args)
  (let ((type (numerical-type (car args))))
    (walk (lambda (x) (if (not (eq? type (numerical-type x)))
			  (error "Numerical type incompatibility ~a ~a" (car args) x)))
	  (cdr args))
    t))


(let ((modular-number-types
       (make-hash-table number? (lambda (x) (mod x *max-fixnum*)) = 'modular-types)))
  (define (FIND-MODULAR-TYPE q)
    (enforce integer? q)
    (cond ((table-entry modular-number-types q))
	  (else (let ((new-type (make-numerical-type)))
		  (set (numerical-type-coercion-function new-type)
		       (lambda (p) (modular-number-constructor p q new-type)))
		  (set (numerical-type-recognizer new-type)
		       (lambda (x) (and (modular-number? x)
					(= (base x) q))))
		  (set (numerical-type-identifier new-type)
		       (string->symbol (format nil "NUMBER-MOD-~a" q)))
		  (set (table-entry modular-number-types q) new-type)
		  new-type)))))

(define-operation (REPRESENTATIVE x) (enforce number? x) x)
(define-predicate MODULAR-NUMBER?)
(define-operation (BASE soi) 0)


(define (MODULAR-NUMBER-CONSTRUCTOR p q type)
  (enforce integer? p)
  (let* ((q (abs q))
	 (p (mod p q)))
    (object nil
      ((numerical-object? soi) t)
      ((numerical-= soi a) (and (= q (base a))
				(= (representative a) p)))
      ((numerical-type soi) type)
      ((numerical-+ soi . args)
       (walk (lambda (x)
	       (enforce modular-number? x)
	       (or (= q (base x)) (error "numerical-+ different modular bases")))
	     args)
       (modular (apply + p (map representative args)) q))
      ((numerical-* soi . args)
       (walk (lambda (x)
	       (enforce modular-number? x)
	       (or (= q (base x)) (error "numerical-* different modular bases")))
	     args)
       (modular (apply * p (map representative args)) q))
      ((numerical-minus soi) (modular (- p) q))
      ((numerical-expt soi num) (modular (expt p num) q))
      ((numerical-=0? soi) (= p 0))
      ((numerical-=1? soi) (or (= p 1) (= q 1)))
      ((numerical-> soi b)
       (if (= q (base b)) (> p (representative b))
	   (> q (base b))))
      ((base soi) q)
      ((representative soi) p)
      ((modular-number? soi) t)
      ((print soi port) (format port "~a|~a" p q)))))

      
(define (MODULAR p q)
  (modular-number-constructor p q (find-modular-type q)))

(lset *mod-2-type* (find-modular-type 2))

