/******************************************************************************
  anf_ceiling_write.c
******************************************************************************/
 
#include "kant.h"

void
anf_ceiling_write WITH_2_ARGS(
	order,		ord,
	anf_ceiling,	ceil
)
/*******************************************************************************
 
Description:
 
	Writes a ceiling.
  
Calling sequence:
 
	anf_ceiling_write(ord, ceil);

	order		ord	= order over which ceil is defined
	anf_ceiling	ceil	= ceiling to write

History:
 
	92-06-04  JS    first version
 
*******************************************************************************/
{
        integer_small   deg, i;
        t_handle          R;
                
        deg = order_abs_degree(ord);
        R   = order_reals(ord);
 
        puts("Ceiling:");
        for (i=1; i<=deg; ++i)
        {
                real_write(R, anf_ceiling_lambda(ceil, i), 40);
                printf("   (");
                integer_write(anf_ceiling_rexp(ceil, i));
                puts(")");
        }       
  
	return;
}

