#include "kant.h"
#include "anf.h"
#include "anf.e"
#include "q.h"
#include "globals.e"
#include "ring.e"
#include "conv.e"
#ifndef KANT
#include "alg.e"
#endif

t_logical
anf_elt_coerce(qring, str, elt, itm, nelt, nitm, do_error)
t_handle	qring;
t_handle	str;
t_handle	elt;
t_int		itm;
t_handle	*nelt;
t_int		*nitm;
t_logical	do_error;
/*
** Lift elt into qring (Anf) ie. lift it into the equation order
*/
{
	block_declarations;
	order		eqord;
	t_logical	res;

	ASSERT (structure_repnum (qring) == REP_ANF);
	*nitm = 0;
	eqord = anf_order_equation(qring);

	switch (ring_type(str))
	{
	case RING_Z:
		*nelt = integer_incref(elt);
		res = TRUE;
		break;
	case RING_ORDER:
		if (order_anf(str) != qring)
			return FALSE;
		res = anf_elt_order_coerce(str, elt, eqord, nelt);
		break;
	default:
		res = FALSE;
	}

	order_delete(&eqord);
	return res;
}

