/******************************************************************************
  anf_elt_is_torsion_unit.c
******************************************************************************/
#include "kant.h"

t_logical
anf_elt_is_torsion_unit WITH_2_ARGS (
	order,		ord,
	anf_elt,	alpha

)
/******************************************************************************
 
Description:	Tests whether an algebraic number is a torsion unit.
 
Calling sequence:
 
	Bool = anf_elt_is_unit(ord,alpha)

	ord	:	the order alpha refers to
	alpha	:	the algebraic number to be tested
	Bool	:	TRUE	alpha is a torsion unit
			FALSE	else
 
History:

	93-02-04 KW	real_zero_eps instead of real_equality_eps,
			order_r1 > 0
	92-06-25 KW	real_equality_eps
	92-06-09 KW	minor changes
	92-06-03 KW	written
 
******************************************************************************/
{
	block_declarations;

	t_handle	R;
	t_logical	bool;
	t_real		tempu,tempv,tempw;
	vector		v;

	if (order_r1(ord)) 
		return(anf_elt_equal(ord,alpha,1) || anf_elt_equal(ord,alpha,-1));

	R = order_reals(ord);	

	v = anf_elt_logs(ord,alpha);
	tempu = vec_ring_dot_product(R,v,v);
	bool  = real_zero_eps(R,tempu,MEM_NH);
	real_delete(&tempu);
	vec_delete(R,&v);

	return(bool);
}
