#include "kant.h"
#include "integer.e"
#include "anf.h"


anf_elt
anf_elt_lift_up WITH_3_ARGS(
	order,		ord1,
	anf_elt,	alpha,
	order,		ord2
)
/*********************************************************************************

Description:

        if ord1 is given as a subfield_order of ord2, alpha (given referring to ord1)
        will be expressed referring to the basis of ord2 and simplified.

Calling sequence:
       
        beta = anf_elt_lift_up(ord1, alpha, ord2);
        
        order           ord1,ord2    = t_handle to order
        anf_elt         alpha,beta   = algebraic numbers 	

History:

        92-05-20 JPS case alpha is conjugate vector
	92-05-11 JPS written
*********************************************************************************/

{
	block_declarations;
 
	anf_elt		beta, gamma, delta, old, coef;
        order		coeff_ord;
	integer_small	i, j, k, deg1, deg2;
        integer_big     old_den;
        t_real          r, r1, old_r, zero;
        t_handle          R;
        matrix          con_tran;

        if (anf_elt_is_integer(alpha) )
                return integer_incref(alpha);

        k = order_subfield_order_count(ord2);
        i = 1;
        while (i<=k && order_subfield_order(ord2, i) != ord1)
                 ++i;
        if (order_subfield_order(ord2, i) != ord1)  
                 {
                 puts("ord1 nicht in ord2 !!");  
                 return;
                 } 
 
        if (anf_elt_is_con(alpha) )
                {
                if (order_subfield_order_con_tran_known(ord2, i) )
                        {
                        R = order_reals(ord1);
                        deg1 = order_abs_degree(ord1);
                        deg2 = order_abs_degree(ord2);
                        con_tran = order_subfield_order_con_tran(ord2, i);
                        anf_con_alloc(gamma, deg2);
                        for (k=1; k<=deg2; ++k)
                                {
                                r = ring_zero(R);
                                for (j=1; j<=deg1; ++j)
                                        {
                                        r1 = real_mult(R, anf_con(alpha, j), mat_elt(con_tran, k, j) ); 
                                        old_r = r;
                                        r = real_add(R, r, r1); 
                                        real_delete(&old_r);
                                        real_delete(&r1);
                                        }
                                anf_con(gamma, k) = r;
                                } 
                        return gamma;
                        } 
                else
                        {
                        printf("Trafo-Matrix nicht vorhanden");
                        return;
                        } 
                }
        else
                {
                coeff_ord = order_coef_order(ord1); 
                gamma = 0;
                deg1 = order_abs_degree(ord1);
                for (j=1; j<=deg1; ++j)
                        { 
                        delta = anf_elt_lift_up(coeff_ord, anf_elt_coef(alpha, j), ord2);
                        beta = anf_mult(ord2, delta, order_subfield_order_basis_elt(ord2, i, j) ); 
                        anf_elt_delref(ord2, &delta);
                        old = gamma;
                        gamma = anf_add(ord2, beta, gamma);
                        anf_elt_delref(ord2, &old);
                        anf_elt_delref(ord2, &beta);
                        }
                old_den = anf_elt_den(gamma);
                anf_elt_den(gamma) = integer_mult( anf_elt_den(gamma), anf_elt_den(alpha) );
                integer_delref(old_den);
                old = gamma;
                gamma = anf_elt_simplify(ord2, gamma);
                anf_elt_delref(ord2, &old);
                return gamma;
                }
        }
