/******************************************************************************
  anf_elt_logs.c
******************************************************************************/

#include "kant.h"
#include "vector.h"
#include "real.e"
#include "anf.h"

vector
anf_elt_logs WITH_2_ARGS(
	order,		ord,
	anf_elt,	alpha
)
/*******************************************************************************
 
Description:

    Computes the logarithms of the absolute values of the conjugate vector of 
    an algebraic number in the actual precision.
 
    alpha might be given as integer, via coefficients or via conjugates. 
    The logarithm vector is stored in a vector with r1+r2 components.
                                        
 
Calling sequence:
 
	vec = anf_elt_logs(ord, alpha);
 
      	order         	ord     = t_handle of order 
        anf_elt         alpha   = algebraic number
        vector          vec     = result
  
      
History:
 
	91-03-24 JS    first version
  
*******************************************************************************/
{
	block_declarations;
 
	integer_small	i, rows, r12;
	t_handle		R;
        vector		vec;
        t_real          temp;
 
 
	order_must_be_over_z(ord);
 
	r12   = order_r1(ord) + order_r2(ord);
	R     = order_reals(ord);
 
/*
   we first compute the absolute values
*/ 
        vec = anf_elt_abs(ord, alpha);
 
                                
/*
   now the logarithms
*/
 
	for (i=1; i<=r12; ++i)
        {
                temp = vec_entry(vec, i);
                vec_entry(vec, i) = real_log(R, temp);
                real_delete(&temp);
        }
 
	return vec;	
}
