/******************************************************************************
  anf_ideal_cap_suborder.c
******************************************************************************/
#include "kant.h"

anf_ideal
anf_ideal_cap_suborder WITH_2_ARGS (
	order,		ord,
	anf_ideal,	ida
)                        
/******************************************************************************
 
Description:	Let ord be an order and ida an ideal of ord. The program
		computes the intersection ida \cap order_suborder(ord).
		    
Calling sequence:
 
	idasub = anf_ideal_cap_suborder(ord,ida);

	ord	: order			= t_handle of order
	ida	: anf_ideal		= ideal of ord

History:

	92-10-09 KW	written
 
******************************************************************************/
{
	block_declarations;

	anf_ideal	idasub;	
	integer_small   i,j,k,n;
	matrix		mata,matb,matc,matd,matu;
	order		subord;

	if (!order_suborder(ord)) error_internal("anf_ideal_cap_suborder: No suborder.");

/*
**	Let w_1,...,w_n be a Z-basis of ord and
**	set T := order_invtran(ord), M := anf_ideal_tran(ida).
**	x in ida \cap suborder satiesfies
**	(i)  x = (w1,...,wn)*T*y
**	(ii) x = (w1,...,wn)*M*z
**	for Z-vectors y,z ==> T*y - M*z = 0 ==> (T|M)(y|z) = 0.
**	To get a Z-presentation of ida \cap suborder we compute the kernel
**	of (T|M). The first n rows of the kernel matrix
**	gives us a Z-presentation of ida.
*/
	n = order_abs_degree(ord);
	anf_ideal_z_assure(ord,ida);
	mata = mat_new(n+n,n);
	for (j=1;j<=n;j++)
	{
		for (k=1;k<=n;k++)
		{
			mat_elt(mata,j,k) = integer_incref(mat_elt(order_invtran(ord),k,j));
			mat_elt(mata,j+n,k) = integer_negate(mat_elt(anf_ideal_tran(ida),k,j));
		}
	}
	matb = mat_z_null_space(structure_z,mata);
	matc = mat_ring_trans(structure_z,matb);
	matd = mat_new(n,n);
	for (j=1;j<=n;j++)
	{
		for (k=1;k<=n;k++)
		{
			mat_elt(matd,j,k) = integer_incref(mat_elt(matc,j,k));
		}
	}
	idasub = anf_ideal_z_create(order_suborder(ord),matd,1);
	mat_delref(structure_z,&mata);
	mat_delref(structure_z,&matb);
	mat_delref(structure_z,&matc);
	mat_delref(structure_z,&matd);

	return(idasub);
}

	
