/******************************************************************************
  anf_ideal_divide_out_ideal_same_p.c
******************************************************************************/
 
#include "kant.h"        


anf_ideal
anf_ideal_divide_out_ideal_same_p WITH_3_ARGS(
	order,		ord,
	anf_ideal,	id1,
	anf_ideal,	id2
)
/*******************************************************************************
 
Description:
             
	Computes an ideal "remainder" so that
		id1 = remainder * id2^const
	and id2 does not divide remainder.
	id1 and id2 must lie above p*oF, p fixed,
	and the "anf_ideal_degrees" of id1 and id2 must be used
	to store the exponent so that we have
		norm(id) = p^expo(id).

	BE CAREFUL!
	In this form this routine should only be called by
	ore_ideal_div_casc and order_prime_factorize_co
	because it works with degree of inertia.
	Mathematically this is of course not correct because this
	degree of inertia is only defined for prime ideals, so
	that we have norm = minimum^degree.
	But here we work with ideals that have norm = p^expo
	( same prime number p for all ideals ) and we avoid
	unnecessary norm calculations when we store the exponents
	in anf_ideal_degree().

	The general function is named anf_ideal_divide_out_ideal.
  
Calling sequence:
 
        order   	ord:        order over which id1 and id2 are defined
        anf_ideal       id1:	    ideal to be divided
        anf_ideal       id2:	    divisor ideal
 
History:

	93-02-12 CO	separated from order_prime_factorize_co.c
			and renamed
	92-09-02 CO	minor changes
	92-07-17 CO     first version

*******************************************************************************/
{       
	block_declarations;
 
	anf_ideal	inverse, remainder, hlp;
	t_int		degree;

	if(( anf_ideal_degree( id1 ) == MEM_NH )
	 ||( anf_ideal_degree( id2 ) == MEM_NH ))
		error_internal("anf_ideal_divide_out_ideal_same_p: Degree unknown.");

	inverse = anf_ideal_invert_integral( ord, id2 );
	remainder = anf_ideal_incref( id1 );

	degree = anf_ideal_degree( remainder );
	anf_ideal_degree( remainder ) = 0;

	anf_ideal_2_assure( ord, remainder);
/*	anf_ideal_min_assure( ord, id2 );*/

/*
Notice: From the algorithm above we know that id2 divides id1 at least once.
*/

	while( ( anf_elt_in_ideal( ord, anf_ideal_gen1( remainder ), id2 ))
	    && ( anf_elt_in_ideal( ord, anf_ideal_gen2( remainder ), id2 ))
	    && ( degree > 0 ) )
	{
	    hlp = remainder;

	    remainder = anf_ideal_mult( ord, hlp, inverse );
	    degree -= anf_ideal_degree( id2 );
	    anf_ideal_2_assure( ord, remainder);

	    anf_ideal_delete( ord, &hlp );
	}
	anf_ideal_delete( ord, &inverse );

	anf_ideal_simplify( ord, &remainder );
	anf_ideal_degree( remainder ) = degree;

	return ( remainder );
}
