/******************************************************************************
  anf_ideal_invert_integral.c
******************************************************************************/
 
#include "stdio.h"        
#include "kant.h"
#include "anf.h"
#include "faclst.h"
#include "faclst.e"

anf_ideal
anf_ideal_invert_integral WITH_2_ARGS(
	order,		ord,
	anf_ideal,	id
)
/*******************************************************************************
 
Description:
                                     
	Returns the inverse ideal of a given integral ideal.
  
Calling sequence:
 
        anf_ideal_invert_integral(ord, id);
 
        order   	ord:    order over which id is defined
        anf_ideal       id:    	integral ideal to be inverted

 
History:

	92-07-17 CO     first version

*******************************************************************************/
{       
	block_declarations;

	anf_ideal	hlp, inverse;
	faclst		factors;
	integer_big	g, b, q, r;
	integer_small	i;
	anf_elt		alpha, beta;
	dyn_arr_handle	rem;

	order_must_be_over_z( ord );

	if( !anf_ideal_is_integral( ord, id ))
		error_internal("anf_ideal_invert: Ideal is not integral.");

	anf_ideal_2_normal_assure( ord, id );

/******* Create the principal ideal < anf_ideal_gen2(id) > and	*******/
/******* determine its minimum of positive integers.		*******/

	alpha = anf_elt_incref( anf_ideal_gen2( id ));
	hlp = anf_elt_to_princ_ideal( ord, alpha );
	anf_ideal_min_assure( ord, hlp );
	b = integer_incref( anf_ideal_min( hlp ));
	anf_ideal_delete( ord, &hlp );

/******* Now factorize the set referring to which a normal presen-  ***/
/******* tation is given (gen_g(id)). Divide the determined minimum ***/
/******* by all these prime factors so that gcd(min, gen_g(id)) = 1 ***/

	g = anf_ideal_gen_g( id );
	integer_lst_factorise( g, &factors, &rem, 50, 1000, 262144, 0, 0, 0, 0, g, 0);
	if( rem )
		error_internal("anf_ideal_invert: Factorization of g failed.");
	for( i = 0; i < faclst_num_prime( factors ); i++ )
	{
		integer_quot_rem( b, faclst_prime( factors, i ), &q, &r );
		while( integer_compare( r, 0 ) == 0 )
		{
			integer_delref( b );
			b = q;
			integer_quot_rem( b, faclst_prime( factors, i ), &q, &r );
		}
		integer_delref( q );
		integer_delref( r );
	}

/******* The remaining rest of the divisions, divided by gen_g(id) ***/
/******* gives the second generator of the inverse ideal of id     ***/
/******* (first generator = 1).                                    ***/

	beta = anf_elt_div( ord, b, alpha );
	inverse = anf_ideal_2_create( ord, 1, beta );

	integer_delref( b );
	anf_elt_delete( ord, &alpha );
	anf_elt_delete( ord, &beta );
	faclst_delete( &factors );

	return( inverse );
}
