/******************************************************************************
  anf_ideal_min_assure.c
******************************************************************************/
 
#include "stdio.h"        
#include "kant.h"
#include "anf.h"

t_void
anf_ideal_min_assure WITH_2_ARGS(
	order,		ord,
	anf_ideal,	id
)
/*******************************************************************************
 
Description:
                                     
	Computes the minimum of positive integers in the integral ideal id,
	if unknown. We use : If the first basis element of ord is 1,
	then the minimum is M(1,1), where M denotes the upper HNF of
	the transition matrix of id ( in Z-Basis-Presentation ).

  
Calling sequence:
 
        anf_ideal_min_assure(ord, id);
 
        order   	ord:    order over which id is defined
        anf_ideal       id:    	integral ideal

 
History:

	92-09-08 CO     gcd ( look at denominators )
	92-06-11 CO     first version

*******************************************************************************/
{       
	block_declarations;
	integer_big	first, gcd, dum1, dum2;

	order_must_be_over_z( ord );

	if( !anf_ideal_is_integral( ord, id ))
		error_internal("anf_ideal_min_assure: Ideal is not integral.");
 
	if ( !anf_ideal_min_known(id) )
	{
		if ( order_one_position( ord ) != 1 )
			error_internal("anf_ideal_min_assure: first basis element of ord is <> 1!");
		anf_ideal_tran_assure_hnf_upper( ord, id );
		if ( !anf_ideal_min_known(id) )
		{
			first = mat_elt( anf_ideal_tran( id ), 1, 1 );
			gcd = integer_gcd( anf_ideal_tran_den( id ), first );
			integer_quot_rem( first, gcd, &dum1, &dum2 );
			anf_ideal_min( id ) = dum1;
			integer_delref( gcd );
			integer_delref( dum2 );
		}
	/******* If anf_ideal_tran_assure_hnf_upper has to call  *******/
	/******* anf_ideal_2_z, the minimum has already been set *******/
	/******* in this routine!				 *******/

	}
}
