#include "kant.h"


t_void 
anf_ideal_norm_equation WITH_6_ARGS (order            , ord   ,
                                     anf_ideal        , ideal ,
                                     integer_small    , K     ,
                                     anf_elt*         , gamma ,
                                     dyn_arr_handle*  , list  , 
                                     t_logical          , find_all )
/*******************************************************************************
 
Description:
 
      Tries to solve the eqaution 
      (*)                         |N(x)| = K        
      in the ideal ideal. The switch find_all indicates whether you want to
      have just on solution or you need all of them.


 
Calling sequence:
 
 
      	order  	        ord      = t_handle of an order 
        anf_ideal       ideal    = checked ideal.

        integer_small   K        = as desc. in (*).

        anf_elt         gamma    = Element solving (*).
        dyn_arr_handle  list     = If you need all sol. of (*) they
                                   will be stored in this dyn. array.

	t_logical         find_all = switch as desc. above.
                                                                  

            anf_ideal_norm_equation (ord,ideal,K,&gamma,&list,find_all);
 
History:
 
	92-06-22 MD     written
 
*******************************************************************************/
{
  
                 block_declarations;

                          
                 lattice        lat;
                 lat_enum_env   lat_env;                    
                                
                 t_logical        is_ideal   = TRUE;
                 t_logical        check_sign = FALSE;



  order_reals_assure (ord);
 

  anf_ideal_lat (ord,ideal,&lat,&lat_env);
  order_lat_norm_equation (ord,ideal,lat,lat_env,K,gamma,list,
                           find_all,is_ideal,check_sign);

  lat_enum_delete(lat, &lat_env);
  lat_delete(&lat);                  
}
