/*******************************************************************************
    anf_ideal_ram_index_p.c
********************************************************************************/


#include "kant.h"




integer_small
anf_ideal_ram_index_p WITH_4_ARGS (order          , ord   ,
                                   integer_big    , p     ,
                                   anf_ideal      , p_ideal ,
                                   integer_small* , bound  )
/*******************************************************************************
 
Description:
   
   Computes the ramification index of the PRIME ideal p_ideal over the rational 
   prime p. Bound should be an upper bound for the ram. index (i.e. the degree of
   the field). If the calling  function does not know such a bound , the varable 
   should equal zero. Then this function will initialize the variable.
                                              

Calling sequence:
                                                           
      order           ord       :  The order start has to be the ring of
                                   integers of a number field.
                               
      integer_big     p         :  A rational prime.
      anf_ideal       p_ideal   :  A prime ideal above p.
      integer_small   bound     :  An upper bound for e(p_ideal/p),or "0".
       
      integer_small   ram_index :  e(p_ideal/p).


          ram_index = anf_ideal_ram_index_p (ord,p,p_ideal,bound);
                            
History:                                 
           
   
   12.08.92 MD    written                    

********************************************************************************/
{
            block_declarations;

            anf_ideal      a,temp;
            

            integer_big    norm,den;
            integer_small  i,f_p_ideal,e;
            t_logical        stop;


  anf_ideal_tran_assure_hnf_upper (ord,p_ideal); 
  anf_ideal_norm (ord,p_ideal,&norm,&den);


  if (den != 1) 
    error_internal ("ANF_IDEAL_RAM_INDEX : ideal is frac. ");


  if (*bound == 0)
    *bound = order_abs_degree (ord);

  f_p_ideal = integer_prime_val (norm,p);
  a         = anf_ideal_incref (p_ideal);
  e         = 1;



  *bound = *bound - f_p_ideal;   /* We already know : p_ideal divides (p) at least once */

  while (f_p_ideal <= *bound)
  {
    
    temp = a;
    a = anf_ideal_mult (ord,a,p_ideal);
    anf_ideal_delete (ord,&temp);    


    anf_ideal_tran_assure_hnf_upper (ord,a); 
    anf_ideal_min_assure (ord,a);  

    if (!anf_elt_in_ideal (ord,p,a)) 
    { 
      anf_ideal_delete (ord,&a);
      return e;                 
    }


    e++;
    *bound = *bound - f_p_ideal;
  }
  anf_ideal_delete (ord,&a);   


  return e;
}
