#include "kant.h"




t_void 
anf_ideal_remainder_init WITH_1_ARG (anf_elt* , alpha)
/*******************************************************************************
 
Description:
      
       Initialization for the computation of a remainder system of an ideal.
       The ideal is not necessary for this.
       The alg. number alpha will step through the remainder-system of the 
       ideal.                             

 
Calling sequence:
 
 
        anf_elt       alpha      : alpha will step through the remainder
                                   system of the ideal.


        alpha  = anf_ideal_remainder_init (&alpha);

History:                                          
 
	92-09-07 MD     written
 
*******************************************************************************/
{

  *alpha = -1;

}


t_void
anf_ideal_remainder_init_sub WITH_3_ARGS (order     , ord   ,
				          anf_ideal , ideal ,
				          anf_elt*  , alpha  )
{
           block_declarations;


           matrix          mat;

	   integer_big     temp1;
           integer_small   n,i;


  order_must_be_over_z (ord);
  n  = order_abs_degree (ord);

  /* First check for a Hermite - Normal form : */
 
  if ( !anf_ideal_is_z (ideal) )
    anf_ideal_2_z (ord,ideal);


  if ( !anf_ideal_tran_is_hnf (ideal) )
    error_internal ("ANF_IDEAL_REMAINDER_INIT : ideal not in HNF ");

  mat = anf_ideal_tran (ideal);


/* allocate memory and "clean" the alg number */
   anf_elt_alloc (*alpha,n);

   anf_elt_den (*alpha) = 1;

   for (i=1;i<=n;i++)  
   {
     temp1 = integer_div (mat_elt (mat,i,i),2);
     anf_elt_coef (*alpha,i) = integer_negate (temp1);

     integer_delref (temp1);
   }

}


t_logical
anf_ideal_remainder_next WITH_3_ARGS (order     , ord   ,
				      anf_ideal , ideal ,
				      anf_elt*  , alpha  )
{                                    
            block_declarations;

            matrix          hnf_mat;

            anf_elt         temp;
            
            integer_big     bound,new; 
            integer_small   i,n;
            
            t_logical         more,ok;

  if (*alpha == -1)    /* This is the first step */
  {
    anf_ideal_remainder_init_sub (ord,ideal,alpha);
    return TRUE;
  }
  else
  {
    n = order_abs_degree (ord);                             

    hnf_mat = anf_ideal_tran (ideal);

    more = TRUE;                   
    ok   = FALSE;

/* We have to delete the element alpha first and then we will        */
/* create it again. This procedure has to be done, since alpha might */
/* be used outside.                                                  */

    anf_elt_alloc (temp,n);
    anf_elt_den (temp) = 1;
    for (i=1;i<=n;i++)  
      anf_elt_coef (temp,i) = integer_incref (anf_elt_coef (*alpha,i));
      
    anf_elt_delete (ord,alpha);
    *alpha = temp;       
       
    i = 1;

    while (TRUE)
    {

      bound = integer_div (mat_elt (hnf_mat,i,i),2);
      new   = integer_add (anf_elt_coef (*alpha,i),1);

      integer_delref (anf_elt_coef (*alpha,i));
   
      if (integer_compare (bound,new) < 0)
      {  

        anf_elt_coef (*alpha,i) = integer_negate (bound);
        integer_delref (new);
        i++;
        if (i > n)
        { 
          integer_delref (bound);
    
          return FALSE;   /* No More elements */

        }                                      
      }                
      else                               
        {                                
          anf_elt_coef (*alpha,i) = new;

          integer_delref (bound);
          return TRUE;
        } 
    }
  }
}


t_logical anf_ideal_remainder_half_check ();



t_logical
anf_ideal_remainder_half_next WITH_3_ARGS (order      ,  ord   ,
					   anf_ideal  ,  ideal ,
					   anf_elt*   ,  alpha  )
{
  
  while (anf_ideal_remainder_next (ord,ideal,alpha) )  
  { 
/* Check now if alpha (k+1) < 0   for k = max { 1<=i<= n | alpha (i) = 0 } */

    if (anf_ideal_remainder_half_check (ord,*alpha) )
      return TRUE;
  }

  return FALSE;

}




t_logical 
anf_ideal_remainder_half_check WITH_2_ARGS (order   , ord,
                                            anf_elt , alpha )
					  
{
          integer_small    i,n;


  n = order_abs_degree (ord);

  i = 1;
  while ( (integer_compare (anf_elt_coef (alpha,i),0) == 0) &&
	  (i < n)                                             )
   i++;

  if (integer_compare (anf_elt_coef (alpha,i),0) < 0)
   return TRUE;
 else
   return FALSE;

}
