/******************************************************************************
  lat_disc_calc.c
******************************************************************************/
 
#include "kant.h"

#define	STD_PREC_DISC 20

void
lat_disc_calc WITH_1_ARG (
	lattice,	lat
)
/*******************************************************************************
 
Description:	Computes the discriminant of a lattice.
		The result is stored inside the lattice structure.
 
Calling sequence:
 
	lat_disc_calc(lat)

	lat	= t_handle of lattice
 
History:

	92-09-10 JS     removed bug when calling ring_elt_incref
	92-05-29 KW	written
 
*******************************************************************************/
{
	block_declarations;

	t_ring_elt	d0,d1,d2;
        
	if ( lat_basis_known(lat)
		 && ( mat_col(lat_basis(lat)) == mat_row(lat_basis(lat)) ) )
	{
		d0 = ring_zero(lat_basis_ring(lat));
		d1 = mat_ring_det(lat_basis_ring(lat),lat_basis(lat));
		if (ring_elt_compare(lat_basis_ring(lat),d1,d0) == -1)
		{
			d2 = d1;
			d1 = ring_negate(lat_basis_ring(lat),d1);
			ring_elt_delete(lat_basis_ring(lat),&d2);
		}

		if (lat_disc_ring(lat))
		{
			if (ring_type(lat_disc_ring(lat)) != RING_R)
				error_internal("lat_disc_create: lat_disc_ring must be R.");
			lat_disc(lat) = (ring_type(lat_basis_ring(lat)) == RING_R)
					? conv_real_to_real(d1,lat_basis_ring(lat),lat_disc_ring(lat))
					: conv_int_to_real(lat_disc_ring(lat),d1);
		}
		else
		{
			lat_disc(lat) = ring_elt_incref(lat_basis_ring(lat), d1);
			lat_disc_ring(lat) = ring_incref(lat_basis_ring(lat));
		}

		ring_elt_delete(lat_basis_ring(lat),&d0);
		ring_elt_delete(lat_basis_ring(lat),&d1);
		return;
	}

	if (!lat_gram_known(lat)) lat_gram_calc(lat);
	d0 = mat_ring_det(lat_gram_ring(lat),lat_gram(lat));

	if (!lat_disc_ring(lat)) 
	{
		if (lat_chol_ring(lat))
		{
			lat_disc_ring(lat) = ring_incref(lat_chol_ring(lat));
		}
		else
		{
			if (ring_type(lat_gram_ring(lat)) == RING_R)
			{
				lat_disc_ring(lat) = ring_incref(lat_gram_ring(lat));
			}
			else
			{
				lat_disc_ring(lat) = real_str_create(STD_PREC_DISC);
			}
		}
	}
	else
	{
		if (ring_type(lat_disc_ring(lat)) != RING_R)
			error_internal("lat_disc_create: lat_disc_ring must be R.");
	}
	d1 = (ring_type(lat_gram_ring(lat)) == RING_R)
			? conv_real_to_real(d0,lat_gram_ring(lat),lat_disc_ring(lat))
			: conv_int_to_real(lat_disc_ring(lat),d0);
	lat_disc(lat) = real_sqrt(lat_disc_ring(lat),d1);
	ring_elt_delete(lat_gram_ring(lat),&d0);
	real_delete(&d1);
}
