/******************************************************************************
  lat_vec_to_ref_vec.c
******************************************************************************/
#include "kant.h"

t_void
lat_vec_to_ref_vec WITH_3_ARGS(
	lattice,	lat,
	lat_enum_env,	env,
	vector,		vec
)

/******************************************************************************
 
Description:	Computes the coefficients of the presentation of vec via
		the basis of lat and stores these coefficients in
		the reference vector of env.
 
Calling sequence:
 
		lat_vec_to_ref_vec(lat,env,vec)

		lattice		lat	: the lattice env refers to
		lat_enum_env	env	: lattice enviroment
		vector		vec	: see above
					  (coefficients over lat_chol_ring(lat))

		!! lat_chol_ring(lat) must be specified. !!
 
History:
 
	92-06-25 KW	mat_real_lin_equatation_system
	92-04-23 KW	written
 
******************************************************************************/
{
	block_declarations;

	integer_small	i;
	matrix		a;
	vector		x;

/*
**	Solve linear equatation system lat_basis(lat)*x = vec.
*/
	if (lat_basis_is_over_z(lat))
	{
		a = mat_z_to_mat_real(lat_chol_ring(lat),lat_basis(lat));
	}
	else
	{
		a = mat_real_to_mat_real(lat_basis_ring(lat),
					 lat_basis(lat),lat_chol_ring(lat));
	}
	x = mat_real_lin_equation(lat_chol_ring(lat),a,vec);

/*
**	Set reference vector
*/
	if (!lat_enum_ref_vector_is_zero(env))
	{
		for(i=1;i<=lat_rank(lat);i++)
		{
			real_delete(&lat_enum_ref_vector_coef(env,i));
		}
		dyn_arr_delete(&lat_enum_ref_vector(env));
	}

	lat_enum_ref_vector(env) = dyn_arr_alloc(lat_rank(lat));
	for(i=1;i<=lat_rank(lat);i++)
	{
		lat_enum_ref_vector_coef(env,i)
		= real_incref(vec_entry(x,i));
	}

	mat_delref(lat_chol_ring(lat),&a);
	vec_delete(lat_chol_ring(lat),&x);
}
