#include "kant.h"
#include "mat.h"
#include "real.e"

matrix
mat_real_mat_z_mult WITH_3_ARGS(
	t_handle,		reals,
	matrix,		matr,
	matrix,		matz
)
/*******************************************************************************
 
mat_real_mat_z_mult.c
 
JS October 1991
Last modification: 18.10.91

Multiplies the real matrix matr by the integer matrix matz by using
higher precision in between.
 
This routine finds out the "precision" of matz (which is the number of decimal 
digits of the largest entry) and performs the actual multiplication in a 
precision high enough to eliminate minimize extortion.
 
However, if the magnitude of one of the resulting elements is extremely
much smaller than the matrix entries this method does not help much.
 
This routine is preliminary. To make it faster it has to be written
using only mp stuff and mp_acc_floats. We wait with that until mp_matrix is 
defined!
 
Also mat_ring_mult is called. This should not be the case: It should multiply
the matrices using for example Winograd's method, see Knuth II.
  
*******************************************************************************/
{
	block_declarations;
        
 	t_handle		newreals;
	matrix		matrnew, matznew, matprod, result;
	integer_big	maxmatz;
	integer_small	precr, precz, precnew;
 
  
 	maxmatz  = mat_z_max(matz); 
	precz    = integer_num_decimal_digits(maxmatz);
	precr    = real_dec_prec(reals);
	precnew  = precr + precz + mat_col(matr);
	newreals = real_str_create(precnew);
       
	matrnew = mat_real_to_mat_real(reals, matr, newreals);
	matznew = mat_z_to_mat_real(newreals, matz);
 
	matprod = mat_ring_mult(newreals, matrnew, matznew);
 
	result  = mat_real_to_mat_real(newreals, matprod, reals);
 
        integer_delref(maxmatz);
        mat_delref(newreals, &matrnew);
        mat_delref(newreals, &matznew);
        mat_delref(newreals, &matprod);
	ring_delete(&newreals);
 
	return result;
}
