/******************************************************************************
  mat_real_to_mat_z.c
******************************************************************************/
 
#include "kant.h"
#include "mat.h"
#include "conv.e"

matrix
mat_real_to_mat_z WITH_2_ARGS(
	t_handle,		reals,
	matrix,	        mat
)
/*******************************************************************************
 
Description:
 
	Casts a real matrix into an integer matrix (rounding!)
 
  
Calling sequence:
 
	mat = mat_real_to_mat_z(R, matr);
 
      	t_handle      R        = t_handle of reals field
      	matrix      matr     = real matrix to be stored
 
  
History:
 
	92-02-25 JS    written
 
*******************************************************************************/
{
	integer_small	m, n, i, j;
	matrix		matz;
 
        m = mat_row(mat);
        n = mat_col(mat);
 
	matz = mat_new(m, n);
                                  
	for (i=1; i<=m; ++i)
	{
		{
		for (j=1; j<=n; ++j)
			mat_elt(matz, i, j) = conv_real_to_int_round(reals, 
							mat_elt(mat, i, j));
		}
	}
 
	return matz;
}
 


