/*******************************************************************************
  mat_z_scalar_div.c
********************************************************************************/



#include <stdio.h>             
#include "kant.h"     
#include "integer.e"
#include "mat.h"
#include "mat.e"                         



   
matrix
mat_z_scalar_div WITH_3_ARGS (t_handle ,     cring,
                              matrix ,     mat1,
			      integer_big, divisor )
/*******************************************************************************

Description:      
           
     Divison  of a matrix over the rational integers through another integer.
     The operations are done in ZZ. So the return value again will be a 
     rational integer matrix.


calling sequence:

               handel        cring   : The ring corresponding to the matrix mat.
                                       Cring has to be a reference to ZZ.
 
               matrix        mat1    : The matrix that will be reduced.
               integer_big   divisor : The value for the reduction.
                                     
               matrix        mat2    : return value of function. Satisfying :

                                        mat1(i,j) = divisor * mat2 (i,j) + r 

                                       with   0<= r < divisor.     


       mat2 = mat_z_scalar_div (cring,mat1,divisor);


History:  
                                                               
       MD 92-01-11         : first version                
  
********************************************************************************/
{         
        block_declarations;
  
        
        matrix            mat2;
        integer_small     row,col,k,l;
     


 if (ring_type (cring)== RING_Z)
 {                           

/* divide matrixelements by den_inv_radical */

    row = mat_row (mat1);
    col = mat_col (mat1);      

    mat2   = mat_new (row,col);


    for (k=1;k<=row;k++)
      for (l=1;l<=col;l++) 
      { 
        mat_elt (mat2,k,l) = integer_div (mat_elt (mat1,k,l),divisor);
      }         

/* end of division */                                  

     return mat2;
  }
}
