/*******************************************************************************
  mat_zm_to_zl.c 
********************************************************************************/



#include "kant.h"     
#include "ring.h"
#include "zm.e"
#include "mat.e"                         






void
mat_zm_to_z WITH_1_ARG (matrix* , mat)
/*******************************************************************************
Description:               
   
   A matrix defined over ZZ/m*ZZ might be used as a matrix over the rational
   integers. This procedure changes the ring_reference of the given matrix.

Calling sequence:                                                          

               matrix      mat : the matrix that has to be changed.
 
      
       mat_zm_to_z (&mat);

                                                                     
History:  
                                                               
       MD 92-01-20         : first version                
  
********************************************************************************/
{
                        
  if (mat_coeff_ring (*mat) == RING_ZM)
    mat_coeff_ring (*mat) = RING_Z;

}
