#include "kant.h"

        

lattice 
order_lat_ceiling_mult WITH_3_ARGS (order        , ord  ,
                                    lattice      , lat  ,
                                    anf_ceiling  , ceil   )
/*******************************************************************************
 
Description:
 
      Transfers the lattice lat into an new lattice (which is the return value).
      The new lattice is defined by the basis of the old lattice and the 
      ceiling (which is just an array of reals). The basis coeffients of the 
      new lattice are as defined in (Pohst,Zassenhaus "Alg. ...".
 
Calling sequence:
 
 
      	order  	        ord      = t_handle of an order 
        lattice         lat      = lattice defined over ord
        anf_ceiling     ceil     = the ceiling defining the new lattice
                                                                       
        lattice         new_lat  = the returned lattice

                                                       
            new_lat = lat_ceiling_mult (ord,lat,ceil);

History:
 
	92-07-24 MD     written
 
*******************************************************************************/
{
           
     	 block_declarations;

         t_handle             R;
         lattice            lat_n;
        
         matrix             basis,basis_n;

         t_real             temp1,temp2,two,lambda;
         integer_small      n,i,j,r1,r2;                



  if (!lat_basis_known (lat)) 
    error_internal ("ORDER_LAT_CEILING_MULT : Lattice has no basis");

  if ( (!lat_basis_is_over_z (lat)) && 
       (lat_basis_ring (lat) != order_reals (ord))
     )
    error_internal ("ORDER_LAT_CEILING_MULT : Different real - fields");
                                  
  if (lat_basis_is_over_z (lat)) 
    puts ("LATTICE IS OVER Z");


/* Ok we can solve the problem */

  lat_n = lat_create ();             /* We will return this lattice */

  lat_rank (lat_n) = lat_rank (lat); /* Set the standard vars       */
  if (lat_disc_known (lat))                                   
  {
    lat_disc (lat_n)      = ring_elt_incref (lat_disc_ring (lat),
                                             lat_disc (lat)      );
    lat_disc_ring (lat_n) = ring_incref (lat_disc_ring (lat));
  }
              

  R     = order_reals (ord);      
  n     = lat_rank (lat);                
  
  r1    = order_r1 (ord);
  r2    = order_r2 (ord);

  temp1 = conv_int_to_real (R,2);
  two   = real_sqrt (R,temp1);
  real_delete (&temp1);          

  basis_n  = mat_new (n,n);                  
  basis    = lat_basis (lat);

  
/* Now transfer the basis */
  for (j=1;j<=n;j++)           /* Step through the coeff`s        */
  {

/* We have to do some add. comp. until we have got the                      */
/* final lambda's :                                                         */
/*                                                                          */
/*                                                                          */
/* We have to do the following :                                            */
/*                --                                                        */
/*                |  sqrt ( ceil (j) )               ;j in [1 , r1]         */
/*  lambda    := -|  sqrt ( ceil (j) + ceil (j+r2) ) ;j in [r1+1 , r1+r2]   */
/*        (j)     |  sqrt ( ceil (j) + ceil (j-r2) ) ;j in [r1+r2+1 , n]    */
/*                --                                                        */

    if ( j <= r1)
      lambda = real_sqrt (R,anf_ceiling_lambda (ceil,j));
    else
      if ( j <= r1+r2) 
      {
        temp1 = real_add (R,anf_ceiling_lambda (ceil,j),
                            anf_ceiling_lambda (ceil,j+r2));
        lambda = real_sqrt (R,temp1);
         
        real_delete (&temp1);
      }
      else
        {
          temp1 = real_add (R,anf_ceiling_lambda (ceil,j),
                              anf_ceiling_lambda (ceil,j-r2));
          lambda = real_sqrt (R,temp1);
          
          real_delete (&temp1);
        }                           
                  
/*    real_delete (&lambda);
      lambda = real_incref (anf_ceiling_lambda (ceil,j));
*/
    for (i=1;i<=n;i++)       /* Step through the basis elements */
    {         

      if (lat_basis_is_over_z (lat))
        temp2 = conv_int_to_real (R,mat_elt (basis,j,i));
      else 
        temp2 = real_incref (mat_elt (basis,j,i)); 
                                        

      if (j > r1)
        temp1 = real_divide (R,temp2,two);
      else
        temp1 = real_incref (temp2);

      mat_elt (basis_n,j,i) = real_mult (R,temp1,lambda);
      
      real_delete (&temp1);
      real_delete (&temp2);
    }                                                  
 
    real_delete (&lambda);
  }
  real_delete (&two);



  lat_basis (lat_n) = basis_n;
  lat_basis_ring (lat_n) = ring_incref (R);             

/* Comupting the Gram - matrix ... */

  lat_gram_calc (lat_n);




  return lat_n;

}


