/******************************************************************************
 order_reals_delete.c                                                           
******************************************************************************/
    
#include "kant.h"

void
order_reals_delete WITH_1_ARG(
	order,		ord
)
/*******************************************************************************
 
Description:
 
        Deletes all real data of an order including the real field used.
 
Calling sequence:
 
	order_reals_delete(ord);

	order	ord	= order under consideration
   
History:
 
	92-06-04 JS     Fincke related data
	92-04-01 JS	deleting unit lattice and its environment
	92-03-19 JS	renaming into order_reals_*
	92-03-12 JS	deletion of dyn_arrays containing order_units
	92-03-05 KW	minor changes
	91-10-01 JS     first version
  
*******************************************************************************/
{
	block_declarations;
 
	t_handle		reals;
         
/*
    Reset?
*/
	if (order_reals(ord) != MEM_NH)
	{
		reals = order_reals(ord);
		real_delete(&order_sqrt_2(ord));
 
		if(order_basis_real_known(ord))
		{
		      mat_delref(order_reals(ord), &order_basis_real(ord));
		      mat_delref(order_reals(ord), &order_basis_real_inv(ord));
		}
 
		if (order_units_logs_known(ord))
                {         
			mat_delref(reals, &order_units_logs(ord));
                        lat_enum_delete(order_units_log_lat(ord),       
                                        &order_units_log_lat_env(ord));
                        lat_delete(&order_units_log_lat(ord));
                }
	 

		if (order_reg_known(ord))
			real_delete(&order_reg(ord));
        
                if (order_fincke_gamma1_known(ord))
			real_delete(&order_fincke_gamma1(ord));
 
                if (order_fincke_lambda_known(ord))
			real_delete(&order_fincke_lambda(ord));
 
		ring_delete(&order_reals(ord));
	}
 
	return;
}
