/******************************************************************************
  order_simplify_trans.c
******************************************************************************/

#include "kant.h"
#include "z.e"
#include "anf.h"
#include "mat.e"


order
order_simplify_trans WITH_1_ARG(
        order,  ord
)
/*******************************************************************************
 
Description:
 
	Simplifies an order.
        The main purpose is to simplify "trees" of transformation
        matrices. 
 
  
Calling sequence:
 
	ordnew = order_simplify_trans(ord);

	order	ord	= order to be simplified
 

History:
 
	92-03-10 JS    trivial cases, reconstruction
	91-11-19 KW    interchange of transformation-matrices
	91-11-01 KW    first version
 
*******************************************************************************/

{
        block_declarations;

        order           neworder, suborder, subsuborder;
        matrix          trans;
        integer_big     den;
        integer_small   ucnt, i;
        t_handle          z;
        void            get_subsuborder();
                                                                  
 
/*
    trivial cases
*/
        if (!order_basis_is_rel(ord)) return order_incref(ord);
         
        suborder = order_suborder(ord);
        if (!order_basis_is_rel(suborder)) return order_incref(ord);
 
/*
    now it is more complicated!
*/
    
        z = m_z_str_incref(structure_z);
         
/*      Unterste Ordnung mit Transformationsmatrix und Nenner ermitteln */

        get_subsuborder(ord, &subsuborder, &trans, &den, z);

        
/*      "Neue" Ordnung anlegen */
          
        neworder = order_trans(subsuborder, trans, den);
         
/*
    some information might be lost. We have to reconstruct it.
    Discriminant comes first:
*/
        if (!order_disc_known(neworder) && order_disc_known(ord)) 
	{
		order_disc(neworder) = integer_incref(order_disc(ord));
        }
 
        if (order_is_maximal(ord)) order_set_is_maximal(neworder);
/*
    handling of units: we shift the units of the old order
    (and delete the units of subsuborder)
*/
 
        if (ucnt=order_units_count(neworder))
        {        
                for (i=1; i<=ucnt; i++)
                        anf_elt_delete(neworder, &order_unit(neworder, i));
        }                                
        ucnt = order_units_count(ord);
        order_units_count_set(neworder, ucnt);
        for (i=1; i<=ucnt; i++)
                order_unit(neworder,i) = anf_elt_incref(order_unit(ord, i));

        if (order_units_are_fund(ord))
                order_set_units_are_fund(neworder);


        mat_delref(z,&trans);
        integer_delref(den);  

        ring_delete(&z);

        return(neworder);
}
                
 
 

void
get_subsuborder WITH_5_ARGS(
        order,          ord,
        order*,         subord,
        matrix*,        trans,
        integer_big*,   den,
        t_handle,         z
)
{
        block_declarations;
                           
        matrix          temp_mat;
        integer_big     temp_big;
                                    
/*      Ordnung ist nicht relativ */

        if (!order_basis_is_rel(ord))   
        {
                *trans  = mat_ring_create_id(z,order_rel_degree(ord));
                *den    = 1;
                *subord = ord;                  

                return;
        }

/*      Ordnung ist relativ, d.h. ueber Transformationsmatrix gegeben */
                                                    
        get_subsuborder(order_suborder(ord),subord,trans,den,z);

        temp_mat = *trans;
        *trans = mat_ring_mult(z,*trans,order_tran(ord));
        mat_delref(z,&temp_mat);

        temp_big = *den;
        *den = integer_mult(order_tran_den(ord),*den);
        integer_delref(temp_big);

        return;
}


