/*******************************************************************************
  order_units_lll_reduce.c 
********************************************************************************/



#include <stdio.h>
#include "kant.h"


void order_units_lll_reduce WITH_1_ARG  (order , ord)
/*******************************************************************************

Description:
  
      Computes a lll reduced system of (independent)  units.                                                                                         
                                                                                            
Calling sequence:       
                                                                  
         order          ord   :  The units of this order are the point of
                                 interrest.
                                                                                               

History:
                                
      MD 93-02-12  first version                                       					

********************************************************************************/
{
            block_declarations;
                     
            t_handle        Z;

            lattice         lat,lll_lat;
            lat_enum_env    lat_env;
           
            dyn_arr_handle  new_units;

            matrix          trans,inv_trans;    
            vector          unit_vec,exp_vec; 

                                        
            anf_elt         tor_unit;
            t_real          regulator;
            integer_small   i,tor_rank;




  if (!order_units_known (ord))
    order_units_calc (ord);

  if (!order_units_are_maximal (ord))
    error_internal ("ORDER_UNITS_LLL_REDUCE : system of units is NOT maximal");
  
  order_reals_assure (ord);

  if (!order_units_logs_known(ord))
    order_units_logs_calc (ord);

  if (order_reg_known (ord))
     regulator = real_incref (order_reg (ord));
  else
     regulator = MEM_NH;                      

  if (order_torsion_unit_known (ord))                       
  {
     tor_unit = anf_elt_incref (order_torsion_unit(ord));
     tor_rank = order_torsion_rank (ord);
  }                           
  else
    tor_unit = MEM_NH;               
 


  Z       = structure_z;        

  lat     = order_units_log_lat (ord);
  lat_env = order_units_log_lat_env (ord); 
  trans=0;
  inv_trans=0;
 
  lll_lat = lat_lll_reduce (lat,&trans,&inv_trans);
   
                
  new_units = dyn_arr_alloc (order_units_count (ord));
  conv_dyn_arr_to_vec (ord,order_unit_basis(ord),&unit_vec);


  for(i=1; i<=order_units_count(ord); i++)    
  {     

    exp_vec = mat_ring_col_to_vector (Z,trans,i);
    dyn_arr_element (new_units,i-1) = anf_elt_power_product (ord,unit_vec,exp_vec);
  
    vec_delete (Z,&exp_vec);
  }

  dyn_arr_curr_length (new_units) = order_units_count (ord);
                               

/* Delete all not needed data */

  mat_delref (Z,&trans);
  mat_delref (Z,&inv_trans);

  order_units_delete (ord);
  vec_delete (ord,&unit_vec);


/* Restore Data      */

  if (regulator != MEM_NH)                          
    order_reg (ord)               = regulator;
  if (tor_unit != MEM_NH)
  {
    order_torsion_unit (ord) = tor_unit;
    order_torsion_rank (ord) = tor_rank;
  }

  order_units_log_lat (ord)     = lll_lat;
  order_units_log_lat_env (ord) = lat_enum_create (lll_lat);
  order_unit_basis (ord) = new_units; 

  order_units_logs_calc(ord);

  return;
}
