#include "stdio.h"        
#include "kant.h"
#include "poly.h"
#include "dyn_arr.h"
#include "anf.h"

t_poly
poly_order_read WITH_2_ARGS(
	order,		ord,
	integer_small,	deg
)
/*******************************************************************************
 
poly_order_read.c
 
JS September 1991 
Last modification: 21.10.91
 
Reads a monic (!) polynomial over an order, decreasing (!) coefficients.
 
*******************************************************************************/
{
	block_declarations;         
                            
	t_poly	pol;
	dyn_arr_handle	arr;
	integer_small	expo, i;
 
	arr = dyn_arr_alloc(deg+1);
	dyn_arr_element(arr, deg) = 1;
 
	for (i=deg-1; i>=0; --i)
		dyn_arr_element(arr, i) = anf_elt_read(ord);
	dyn_arr_curr_length(arr) = deg +1;
 
	pol = dyn_arr_to_poly(ord, arr);
 
	for (i=0; i<=deg; ++i)
		anf_elt_delete(ord, &dyn_arr_element(arr, i));
	dyn_arr_delete(&arr);
 
	
 
	return pol;
}
