#include "mem.h"

t_void mem_show_analysis()
{
#ifdef ANALYSIS
    mem_printf("get_block: %d\n", memi_analysis_get_block);

    mem_printf(
	"get_block average size: %g\n",
	(double)memi_analysis_total_get_block / memi_analysis_get_block
    );

    mem_printf(
	"get_block average lists examined: %g\n",
	(double)memi_analysis_list_count / memi_analysis_get_block
    );

    mem_printf(
	"get_block average list blocks examined: %g\n",
	(double)memi_analysis_block_count / memi_analysis_get_block
    );

    mem_printf(
	"get_block number of spare blocks: %d (%g%%)\n",
	memi_analysis_spare_block,
	100 * (double)memi_analysis_spare_block / memi_analysis_get_block
    );

    mem_puts("");
    mem_printf("free_block: %d\n", memi_analysis_free_block);

    mem_printf(
	"free_block average size: %g\n",
	(double)memi_analysis_total_free_block / memi_analysis_free_block
    );

    mem_printf(
	"free_block average list blocks examined: %g\n",
	(double)memi_analysis_free_block_count / memi_analysis_free_block
    );

    mem_puts("");
    mem_printf("coalesce: %d\n", memi_analysis_coalesce);

    mem_printf(
	"coalesce average original size: %g\n",
	(double)memi_analysis_coalesce_original / memi_analysis_coalesce
    );

    mem_printf(
	"coalesce number of right blocks: %d (%g%%)\n",
	memi_analysis_coalesce_right,
	100 * (double)memi_analysis_coalesce_right / memi_analysis_coalesce
    );

    mem_printf(
	"coalesce number of left blocks: %d (%g%%)\n",
	memi_analysis_coalesce_left,
	100 * (double)memi_analysis_coalesce_left / memi_analysis_coalesce
    );

    mem_printf(
	"coalesce number of both blocks: %d (%g%%)\n",
	memi_analysis_coalesce_both,
	100 * (double)memi_analysis_coalesce_both / memi_analysis_coalesce
    );

    mem_printf(
	"coalesce number of no changes: %d (%g%%)\n",
	memi_analysis_coalesce_none,
	100 * (double)memi_analysis_coalesce_none / memi_analysis_coalesce
    );

    mem_printf(
	"coalesce average after size: %g\n",
	(double)memi_analysis_coalesce_after / memi_analysis_coalesce
    );
#endif
}
