#include "mem.h"

t_void memi_clean()
/*
Clean the whole space of handle blocks.
*/
{
    t_ptr	begin, nextp, next, hp, fp, fp_limit;
    t_int	old_checking;

    old_checking = mem_do_enter_check;
    mem_do_enter_check = FALSE;

    for (fp = (t_ptr)memi_free_lists; fp < (t_ptr)memi_free_limit; fp++)
	DEREF(fp) = NULL;

    begin = memi_base_mem;

    while (begin < memi_high_mem)
    {
	nextp = (t_ptr)&NEXT_BLOCK(begin);
	next = DEREF(nextp);
	hp = BLOCK_HANDLE(begin);
	if (hp == P_HANDLE_TABLE || !IS_SPECIAL(hp))
	{
	    while (next < memi_high_mem)
	    {
		hp = BLOCK_HANDLE(next);
		if (hp == P_HANDLE_TABLE || !IS_SPECIAL(hp))
		    next = NEXT_BLOCK(next);
		else
		    break;
	    }

	    DEREF(nextp) = next;
	    PREV_BLOCK(next) = begin;

	    memi_free_block(begin);
	}

	begin = next;
    }

    DEVELOP_ONLY(
	free(memi_trace_h_table);
	free(memi_trace_size_table);
    )

    mem_reset_stats();
    TRACE_INIT();
    mem_do_enter_check = old_checking;
}

t_void mem_clear()
/*
Clear the space of handle blocks and re-initialize the handle table.
*/
{
    t_int	old;

    old = mem_do_enter_check;
    mem_do_enter_check = 0;

    HANDLE_BASE = NULL;
    memi_clean();
    memi_extend_handle_table();

    mem_do_enter_check = old;
}
