# Default Make-Include-file for Kant V2        JS January 1992
#
# This "partial" Makefile should be included in all
# Makefiles for programs using Kant V2. The directory
# in which this Makefile.inc is found should be in the
# variable $(V2). The Makefile which includes this file
# has to set V2.
# 
 
# 
#  Paths
#
   
MEM             = $(V2)/MEM
PLAT            = $(V2)/Platform
INCLUDE         = $(V2)/include
ANF             = $(V2)/Anf
THUE            = $(V2)/Thue
RELNEQ          = $(V2)/Relneq
RELITB          = $(V2)/Relitb
FORTRAN         = $(V2)/f
V2MAINS         = $(V2)/mains
 
#
#   Object Libraries
#
 
MEMOBJS         = $(MEM)/access.o $(MEM)/check.o $(MEM)/clean.o $(MEM)/coalesce.o $(MEM)/creator.o \
		$(MEM)/block.o $(MEM)/handle.o $(MEM)/init.o $(MEM)/malloc.o $(MEM)/more_data.o $(MEM)/save.o \
		$(MEM)/set.o $(MEM)/show.o $(MEM)/stats.o $(MEM)/trace.o $(MEM)/support.o $(MEM)/analysis.o \
		$(MEM)/compact.o

PLATOBJ         = $(PLAT)/OBJLIB.o
ANFOBJ          = $(ANF)/OBJLIB.o
THUEOBJ         = $(THUE)/OBJLIB.o
RELNEQOBJ       = $(RELNEQ)/OBJLIB.o
RELITBOBJ       = $(RELITB)/OBJLIB.o
FORTOBJ         = $(FORTRAN)/OBJLIB.o
 
#
#   The inlib library of Kant V2 
#   (including all functions of Platform, Extended and Anf)
#   $(ARLIB) contains the archived objects
#

INLIB		= $(V2)/lib/Kant2.o
ARLIB           = $(V2)/lib/libKant2.a
 
#
#   C-Compiler and Fortran Compiler
#              
 
CC 		= /bin/cc

# Develop version:
#DEV_EXP		= -g -DAPOLLO -DDEVELOP $(DEVELOP_FLAGS)
# Export version:
DEV_EXP			= -DPOSH

OPT		=
CFLAGS 	        = -c -W0,-pic -r -a $(OPT) -Yp,/usr/lib          \
                  $(DEV_EXP) -DKANT -DDO_NOT_USE_PROTOTYPES     \
                  -I$(INCLUDE) $(LOCAL_DEFS)
CFLAGSII        = -c -W0,-pic -r -a -A nansi $(OPT) -Yp,/usr/lib \
                  $(DEV_EXP) -DKANT -IDDO_NOT_USE_PROTOTYPES     \
                  -I$(INCLUDE) $(LOCAL_DEFS)
FTN             = /usr/bin/f77
FTNFLAGS        = -c -W0,-pic -W0,-ndb
 
#
#   Link editor for binding libraries and executable programs
#
 
BIND		= ld
BINDFLAGS	= -r -a -A allmarks -A noallres
LINK            = ld
LINKFLAGS       = -r -a -A inlib,$(INLIB)
 
# 
#   Syntax for building object files
#

.SUFFIXES: .c .f .o .x

.c.o:
	$(CC) $(CFLAGS) $*.c
 
.f.o:   
	$(FTN) $(FTNFLAGS) $*.f
  
.o.x:
	$(LINK) -o $@ $(LINKFLAGS) $*.o $(LOCLIB)
 

