#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"
#include "faclst.e"
#include "faclst.h"

#define	MINEXTN	2

void
i_put_prime_in_factors WITH_3_ARGS(
	faclst,	flist,
	integer_big,	pr,
	t_int,	exp
)
/*
** input:  flist - prime factor list (t_handle of type faclst)
** prime - prime to be added (general integer)
** exp - corresponding exponent (may be negative!)
** output: prime and exp are added to flist; the primes are listed in
** ascending order.
*/
{
        block_declarations;

	register t_int	i;
	register t_int	j;
	t_int		index;
	t_int		topindex;
	Logical			found;
	Logical			flag;

	topindex = faclst_num_prime( flist );
	index = topindex;
	found = FALSE;
	for(i=0; i < topindex ; i++)
	{
		flag = integer_compare(pr, faclst_prime(flist, i));
		if ( flag == 0 )
		{
			faclst_expon( flist, i) += exp;
			if((faclst_expon(flist, i) == 0) && (exp < 0))
			{
				for(j=i+1 ; j<topindex ; j++)
				{
					faclst_prime(flist,j-1) =
						faclst_prime(flist,j);
					faclst_expon(flist,j-1) =
						faclst_expon(flist,j);
				}
				faclst_num_prime(flist)--;
				topindex--;
				faclst_reduce(flist, topindex);

			}
			found = TRUE;
			break;
		}
		else if ( flag == -1 )
		{
			index = i;
			break;
		}
	}

	if(found == FALSE)
	{
		faclst_assure_space(flist, topindex + 1, MINEXTN);
		for(i=topindex - 1; i >= index ; i--)
		{
			faclst_prime(flist, i+1) = faclst_prime(flist, i);
			faclst_expon(flist, i+1) = faclst_expon(flist, i);
		}
		faclst_prime(flist, index) = integer_incref( pr );
		faclst_expon(flist, index) = exp;
		faclst_num_prime(flist) = topindex + 1;
	}

	faclst_num_expon( flist ) += exp;
} 
