#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"

integer_big
integer_nfactorial   WITH_1_ARG(
    t_int,  aint
)
/*
** input:  aint- positive single-precision integer
** output: returns general integer = aint!
** allocate storage for result and temporary result.
*/
{
    block_declarations;
#if integer_BETA == 536870912

    static t_int	small_fact[] = 
    { 1, 1, 2, 6, 24, 120, 720, 5040, 40320, 362880, 3628800, 39916800 };
#define SMALL_LIMIT	sizeof(small_fact) / sizeof(t_int)

#else
	die!!!
#endif
    register t_int  i;
    inthdl_handle   result;
    inthdl_handle   rtemp;
    inthdl_length   rlen;
    register inthdl_handle  temp;

    if (aint < 0)
	error_internal("integer_nfactorial: negative argument");

    if (aint < SMALL_LIMIT)
	return small_fact[aint];

    result = inthdl_alloc(aint);
    rtemp = inthdl_alloc(aint);

    intbig_sign(result) = 1;
    intbig_digit(result, 0) = 1;
    intbig_curr_size(result) = 1;

    i = 2;
    while (i <= aint)
    {
	t_int	last, multiplier, limit;

	if ((last = i + SMALL_LIMIT) > aint)
	    last = aint;

	limit = (integer_BETA - 1) / last;

	multiplier = i++;

	while (i <= last && multiplier <= limit)
	    multiplier *= i++;

	if (multiplier >= integer_BETA)
		printf("huh: %\n", multiplier);

	rlen = intbig_curr_size(result) + 1;
	intbig_assure_space(rtemp, rlen, 10);
	inthdl_mult_beta(result, multiplier, rtemp);
	temp = result;
	result = rtemp;
	rtemp = temp;
    }

    inthdl_delref(rtemp);

    /*
     * convert result to a valid integer.
     */

    return inthdl_standardize(result);
}
