/*  integer_power.c
*/

#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"


integer_big
integer_power	WITH_2_ARGS(
    integer_big,	aint,
    t_int,	n
)
/*
Given a single or multi-precision integer aint and a single-precision
integer n, return aint raised to the power of n provided it is a well-
defined integer.  Signal an error via bh_err_general() otherwise, that
is, in the cases n multi-precision, or n negative, or aint = n = 0.
*/
{
    block_declarations;

    inthdl_handle   result;
    inthdl_handle   ahdl;

    DENY(n < 0 || (integer_sign(aint) == 0 && n == 0));
    DENY(!integer_is_single(n));

    if (integer_sign(aint) == 0)
	return 0;

    if (integer_compare(aint, -1) == 0)
	return (n & 1) ? -1 : 1;

    if (integer_compare(aint, 1) == 0 || n == 0)
	return 1;

    if (n == 1)
	return integer_incref(aint);

    if (aint == 2)
    {
	return integer_shift_left(1, n / ZETA, n % ZETA);
    }

    if (integer_is_single(aint))
        ahdl = inthdl_alloc_1(aint);
    else
	ahdl = inthdl_incref(inthdl_big_to_handle(aint));

    result = inthdl_buf_alloc(n * intbig_curr_size(ahdl));
    inthdl_power(ahdl, n, result);
    inthdl_delref(ahdl);

    return inthdl_standardize(result);
}
