/*  integer_sign.c
*/

#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"


t_int
integer_sign WITH_1_ARG(
    integer_big, aint
)
/*
Return -1, 0, 1 according to whether aint is negative, zero or positive
*/
{
    t_int	s;

    if (aint == 0)
	return 0;

    if (integer_is_single(aint))
	s = aint;
    else
	s = intbig_sign(inthdl_big_to_handle(aint));

    return s > 0 ? 1 : -1;
}
