#include <stdio.h>
/*  inthdl_standardize.c
*/

#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"

#define ERRMESSIZ	128

integer_big
inthdl_standardize	WITH_1_ARG(
    inthdl_handle, h
)
/*
Convert the integer in the block with t_handle h into standard form.  First
check that there are no trailing zero beta-digits.  Then, if less than two
beta-digits remain, remove the block and return a small integer; otherwise
reduce the block and return an integer_big consisting of the t_handle h in
specially marked form.

The t_handle h can be a buffer - if in this case the result needs to be stored
in a block, a proper block is allocated and the data copied.  Otherwise (in
the case that h is a proper block), this function performs a TRANSFER of
reference from the argument to the variable to which the returned result
is assigned.  It does NOT increment the reference count of its argument
in the case when the result is equal to the argument.

It is intended that inthdl_standardize will only be called with an argument h
which is a buffer or whose reference count is exactly one; the calling routine
has created h and will return it in disguised integer_big form as its own return value.
*/
{
    inthdl_length	k;
    t_int	val, space;

    DEBUG_INTHDL_1("+inthdl_standardize", h);

    if (intbig_sign(h) == 0)
    {
#if 0
	if (inthdl_is_buf(h))
	{
	    inthdl_buf_delete(h);
	}
	else
#endif
	{
	    ASSERT(block_ref_count(h) == 1);
	    inthdl_delref(h);
	}

	DEBUG_INTEGER_1("-inthdl_standardize", 0);
	return 0;
    }

    k = intbig_curr_size(h);

    if (k == 1)
    {
	val = intbig_sign(h) * intbig_digit(h, 0);

#if 0
	if (inthdl_is_buf(h))
	{
	    inthdl_buf_delete(h);
	}
	else
#endif
	{
	    ASSERT(block_ref_count(h) == 1);
	    inthdl_delref(h);
	}

	DEBUG_INTEGER_1("-inthdl_standardize", val);
	return val;
    }

#if 0
    if (inthdl_is_buf(h))
    {
	/*
	Copy the buffer into a proper allocated block.
	*/

	inthdl_handle		buf;

	buf = h;
	h = inthdl_alloc(k);
	intbig_sign(h) = intbig_sign(buf);		/* NB: not zero */
	intbig_copy_digits(buf, 0, k, h, 0);
	intbig_curr_size(h) = k;
	inthdl_buf_delete(buf);
    }
    else
#endif

    if ((space = intbig_required_space(k)) < intbig_current_space(h) - 5)
    {
	/*
	Don't reduce every time - only when there's a reasonable amount
	of space to save.
	*/

	mem_reduce_words(h, space);
    }

    DEBUG_INTHDL_1("-inthdl_standardize", h);

    return inthdl_handle_to_big(h);
}
