#include "defs.h"
#include "vector.h"
#include "mat.h"
#include "dyn_arr.h"

#undef A
/* matrix seems to be another reserved word */
t_handle
mat_fld_null_space	WITH_2_ARGS(
    t_handle,	ring,
    t_handle,	matrixx
)
{
    /*
     *	Given a m x n matrix A over a field, return a basis of the kernel of A
     *		i.e., of row vectors V such that VA = 0
     *  Algorithm 2.4.10 from:
     *	  "A Course in Algorithmic Algebraic Number Theory", H. Cohen
     */
    
    t_int		i, j, k, l, m, n, r;
    t_handle	A, chdl, basis, V;
    t_int		zero, one, minus1, temp, scale;
    t_pfh	field_div;
    t_pfh	ring_multn;

    /*
     *	Step 1: Initialize
     */
    m = mat_row(matrixx);
    n = mat_col(matrixx);
    A = 0;
    mat_create_unpkd_copy(ring, matrixx, A, m, n);
    chdl = dyn_arr_alloc(n);
    basis = dyn_arr_alloc(m);
    zero = ring_zero(ring);
    one = ring_one(ring);
    minus1 = ring_minus1(ring);
    field_div = ring_slash_op(ring);
    ring_multn = ring_multiplication(ring);

    r = 0;
    k = 1;
    for (i = 0; i < n; i++)
	dyn_arr_element(chdl, i) = 0;

    do
    {
	/*
	 *	Step 2:	Scan column
	 */
	for (j = 1; j <= n; j++)
	{
	    if (mat_elt(A, k, j) == zero || dyn_arr_element(chdl, j - 1) != 0)
		continue;
	    break;
	}

	if (j > n)
	{
	    V = vec_new(m);
	    for (i = 1; i <= m; i++)
		vec_entry(V, i) = zero;
	    vec_entry(V, k) = one;
	    for (i = 0; i < n; i++)
		if (dyn_arr_element(chdl, i))
		    vec_entry(V, dyn_arr_element(chdl, i)) = mat_elt(A, k, i+1);
	    dyn_arr_element(basis, r) = V;
	    r++;
	}
	else
	{
	    /*
	     *  Step 4: Pivot
	     */
	    scale = (* ring_multn)(ring, mat_elt(A, k, j), minus1);
	    for (i = 1; i <= m; i++)
		mat_elt(A, i, j) = (* field_div )(ring, mat_elt(A, i, j), scale);
	    for (l = 1; l <= n; l++)
	    {
		if (l == j)
		    continue;
		scale = mat_elt(A, k, l);
		for (i = 1; i <= m; i++)
		{
		    temp = ring_mult(ring, scale, mat_elt(A, i, j));
		    mat_elt(A, i, l) = ring_add(ring, mat_elt(A, i, l), temp);
		}
	    }
	    dyn_arr_element(chdl, j - 1) = k;
	}

    /*
     *	Step 3: Finished?
     */
    }	while (k++ < m);

    dyn_arr_curr_length(basis) = r;
    block_decref_delete(chdl);
    mat_delref(ring, &A);

    return basis;
}
