#include "defs.h"
#include "integer.e"
#include "ring.h"
#include "mat.h"

t_void 
mat_ring_create_minus1_sub WITH_2_ARGS(
	t_handle,		cring,
	matrix *,	mat
)
/* 
** Creates the negative of identity matrix over coefficient ring cring in *mat.
** Assumes "*mat" has been allocated, is square and is unpacked.
*/
{
	register t_int	j;
	register t_int	diag;
	register t_int	dim2;
	register t_int	*ptr_mat;
	t_int	zero;
	t_int	minus1;
	t_int	n;

	if (mat_is_packed(*mat))
		error_internal("Given packed matrix in CREATE_MINUS1");

	n = mat_row(*mat);
	if (n != mat_col(*mat))
		error_internal("Matrix not square in CREATE_MINUS1");

	zero = ring_zero(cring);
	minus1 = ring_minus1(cring);

	ptr_mat = mat_elt0_ptr(*mat);
	dim2 = n * n;

	for (j = 1; j <= dim2; j++)
		ptr_mat[j] = zero;
	diag = n + 1;
	for (j = 1; j <= dim2; j += diag)
		ptr_mat[j] = minus1;

	mat_incref_entries( cring, *mat );
	ring_elt_delete( cring, &zero );
	ring_elt_delete( cring, &minus1 );

	return;
}


matrix 
mat_ring_create_minus1 WITH_2_ARGS(
	t_handle,		cring,
	integer_small,	dim
)
/*
** Returns the negative of identity matrix, dim by dim, over coefficient ring
** cring.
*/
{
	matrix c;

	c = mat_new( dim, dim );
	mat_ring_create_minus1_sub( cring, &c );
	return c;
}

