
#include "defs.h"
#include "ring.h"
#include "mat.h"
#include "zm.e"
#include "error.e"

/*
 * This file includes
 *
 *	mat_ring_insert_sub()      - sub function
 *	mat_ring_insert()          - Insert a matrix into a larger one
 */


t_void
mat_ring_insert_sub WITH_6_ARGS(
t_handle,	cring,
matrix,	a,
matrix,	b,
integer_small,	row,
integer_small,	col,
matrix*,	pc
)
/*
 * Insert the matrix "b" into the larger matrix
 * "a" beginning at the (row,col) position,
 * and giving resulting matrix "c".
 *
 * "cring" is the coefficient ring.
 * row and col start counting at one.
 */
{
	block_declarations;
	register t_int	i;
	register t_int	j;
	register t_int	r1;
	register t_int	r2;
	register t_int	posn;
	register t_int*	ptr_a;
	register t_int*	ptr_b;
	register t_int*	ptr_c;
	register integer_small	am;
	register integer_small	an;
	register integer_small	bm;
	register integer_small	bn;
	register integer_small	dim2;
	integer_big	modulus;
	t_handle	ringtype;
	matrix	mata;
	matrix	matb;
	matrix	matc;
	Logical	respack;

	mata = matb = matc = 0;
	am = mat_row(a);		an = mat_col(a);
	bm = mat_row(b);		bn = mat_col(b);

	DENY ( bn + col > an + 1 || col <= 0 || bm + row > am + 1 || row <= 0 );
	/*
	 * invalid row and/or column number
	 */

	respack = mat_result_pkd(cring, *pc);
	mat_alloc_result_unpkd(respack, *pc, matc, am, an);
	mat_create_unpkd(cring, a, mata, am, an);
	mat_create_unpkd(cring, b, matb, bm, bn);

	ringtype = ring_type(cring);
	if (ringtype == RING_ZM)
		modulus = zm_modulus(cring);

	/*
	 * Firstly, the copying of "a" to "c" is done by 4 blocks,
	 * each corresponding to one side of the place where "b" is
	 * to be put.
	 * Then, "b" is copied into place.

		 --------(an)---------
		 |       top         |
		 |                   |
		 |.....-(bn)--.......|
		(am)   |     |       |
		 |left |  b  | right |
		 |   (bm)    |       |
		 |.....|-----|.......|
		 |      bottom       |
		 ---------------------

	 */

	ptr_a = mat_elt0_ptr(mata);
	ptr_b = mat_elt0_ptr(matb);
	ptr_c = mat_elt0_ptr(matc);

	r1 = 0;
	for (i = 1; i < row; i++)		/* copy top bit */
	{
		for (j = 1; j <= an; j++)
		{
			posn = r1 + j;
			ptr_c[posn] = ptr_a[posn];
		}
		r1 += an;
	}

	r1 = (row - 1) * an;
	if (col > 1)					/* copy left bit */
	{
		for (i = 1; i <= bm; i++)
		{
			for (j = 1; j < col; j++)
			{
				posn = r1 + j;
				ptr_c[posn] = ptr_a[posn];
			}
			r1 += an;
		}
	}

	r1 = (row - 1) * an;
	if (col + bn - 1 < an)		/* copy right bit */
	{
		for (i = 1; i <= bm; i++)
		{
			for (j = col + bn; j <= an; j++)
			{
				posn = r1 + j;
				ptr_c[posn] = ptr_a[posn];
			}
			r1 += an;
		}
	}

	r1 = (row + bm - 1) * an;
	for (i = 1; i <= am - (row + bm) + 1; i++)	/* copy bottom bit */
	{
		for (j = 1; j <= an; j++)
		{
			posn = r1 + j;
			ptr_c[posn] = ptr_a[posn];
		}
		r1 += an;
	}


	r1 = (row - 1) * an + col - 1;
	r2 = 0;
	/*
	 * Now copy b
	 */
	for (i = 1; i <= bm; i++)
	{
		for (j = 1; j <= bn; j++)
		{
			ptr_c[r1 + j] = ptr_b[r2 + j];
		}
		r1 += an;
		r2 += bn;
	}

	mat_incref_entries(cring, matc);
	mat_create_result(cring, respack, *pc, matc);
	mat_free_unpkd(a, mata);
	mat_free_unpkd(b, matb);
}



matrix 
mat_ring_insert WITH_5_ARGS(
	t_handle,		cring,
	matrix, 	a,
	matrix,		b,
	integer_small,		row,
	integer_small,		col
)
/* 
 *	Insert the matrix "b" into the larger matrix
 *	"a" beginning at the (row,col) position,
 *	returning resulting matrix "c".
 *
 *	"cring" is the coefficient ring.
 *	row and col start counting at one.
 *
 *	It calls mat_ring_insert_sub
 */
{
	matrix c = 0;

	(t_void) mat_ring_insert_sub(cring, a, b, row, col, &c);
	return c;
}


