#include "defs.h"
#include "integer.e"

t_int
mintd_exp WITH_3_ARGS(
    t_int,    mdig,
    t_int,    adig,
    t_int,    ndig
)
/*
** input:  mdig - positive beta-digit
** adig - beta-digit in z mdig
** ndig - non-negative beta-digit
** output: imdexp = adig ** ndig in z mdig
** computes modular digit exponentiation.  the exponentiation
** adig ** ndig is computed modulo mdig
*/
{
	register t_int    result;
	register t_int    ndash;
	register t_int    atemp;

	/*
	 * case result is zero
	 */
	if (adig == 0 && ndig > 0)
	{
		return 0;
	}
	/*
	 * case result is non-zero...
	 */
	result = 1;
	ndash = ndig;
	atemp = adig;
	/*
	 * start of while loop to compute exponentiation in result
	 */
	for (;;)
	{
		if (ndash & 1)
			result = mintd_mult(mdig, result, atemp);
		if ((ndash >>= 1) == 0)
			break;
		atemp = mintd_mult(mdig, atemp, atemp);
	}
	/*
	 * end of while loop, result is exponentiation
	 */
	return result;
}
