#include "modint.e"

integer_big
modint_symm_rep WITH_2_ARGS(
integer_big,	mint,
integer_big,	aint
)
/* 
** modint_symm_rep : SMFMI in SAC code.
** "Wraps" an element of Zm to an integer in the
** range [-m/2, m/2). 
*/
{
	integer_big	quot;
	t_int		rem;
	integer_big	upper, lower;
	integer_big	temp, bint, res;
	block_declarations;

	integer_quot_rem(mint, 2, &quot, &rem);
	if (rem)
		upper = integer_incref(quot);
	else
		upper = integer_subtract(quot, 1);

	lower = integer_negate(quot);
	
	integer_delref(quot);

	if (integer_compare(aint, upper) > 0)
	{
		temp = integer_subtract(aint, upper);
		bint = integer_subtract(temp, 1);
		res = integer_add(lower, bint);
		integer_delref(temp);
		integer_delref(bint);
	}
	else
		res = integer_incref(aint);

	integer_delref(upper);
	integer_delref(lower);
	return res;
}
	
