#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "modint.e"

t_poly
modpoly_hom WITH_3_ARGS(
        t_handle,       pring,
        integer_big,    mdig,
        t_poly,      apoly
)
/*
** modpoly_homomorph : modular polynomial homomorphism.
** apoly is an integral polynomial,
** returns Hsubm(apoly), a polynomial over Zsubmdig
*/
{
    t_handle           aph;
    t_handle           resph;
    t_int    anterms;
    t_int    termno;
    t_poly        acoefft;

    if ( m_poly_const( apoly ) )
    {
        return modint_hom( mdig, apoly );
    }

    /* non-trivial polynomial */

    aph = m_poly_poly_to_handle( apoly );
    anterms = m_poly_nterms( aph );
    m_poly_create_empty( &resph, m_poly_princvar( aph ),
                                      m_poly_least_pvar (aph), anterms );

    if (m_poly_univariate (aph))
    {
        for ( termno = 0; termno < anterms; termno++ )
        {
            acoefft = m_poly_coefft( aph, termno );
            m_poly_coefft( resph, termno ) = 
                                            modint_hom (mdig, acoefft);
            m_poly_expt( resph, termno ) = m_poly_expt( aph, termno );
        }
    }
    else
    {
        for ( termno = 0; termno < anterms; termno++ )
        {
            acoefft = m_poly_coefft( aph, termno );
            m_poly_coefft( resph, termno ) =
                                          modpoly_hom( pring, mdig, acoefft );
            m_poly_expt( resph, termno ) = m_poly_expt( aph, termno );
        }
    }

    return poly_z_clean( pring, m_poly_handle_to_poly( resph ));
}

