#include "defs.h"
#include "mp.e"
#include "mp.h"
#include "system.h"

mp_float
mp_a_to_mp	WITH_2_ARGS(
	char *,		s,
	mp_float,	z
)
/*
Scans the string s for a decimal floating point number which is placed in z
and then returned.  The number is placed in z in z's internal base.
Only decimal digits in the string are considered to be legal.  A UNIX regular
expression denoting the legal input strings is:

	-?[0-9]*(\.[0-9]*)?(e-?[0-9]*)?
*/
{
    mp_build_context	b;

    DEBUG_BEGIN(DEBUG_OTHER);
    DEBUG_PRINTF_1("+a_to_mp {\n");
    DEBUG_PRINTF_2("s = %s\n", s);

    b = mp_build_start(z, 10);

    for (; *s; s++)
	switch (*s)
	{
	case '-':
	    mp_build_minus(b);
	    break;

	case '.':
	    mp_build_point(b);
	    break;

	case 'e':
	    mp_build_expt(b);
	    break;

	default:
	    if (isdigit(*s))
		mp_build_digit(b, *s - '0');
	    else
		mp_error("mp_a_to_mp: illegal character (%c) encountered", *s);
	}

    mp_build_finish(&b);

    DEBUG_1("-} z = ", mp_ptr(z));

    DEBUG_END();
    return z;
}
