#include "defs.h"
#include "mp.e"
#include "mp.h"


mp_float
mp_int_to_mp	WITH_2_ARGS(
	mp_int,	ix,
	mp_float,	z
)
/*
Converts integer ix to mp float z and returns z (called mpcim in Brent).
Assumes that int_abs(ix) <= b^t (otherwise ix can not usually be represented
exactly as an mp number).
*/
{
    /*
    Brent copied the integer into the last digit and multiplied by 1 using
    mp_mul_int() to normalize, but this will not work here, since the integer
    size may be larger than the size of a digit.
    */

    mp_ptr_type		zp = mp_ptr(z);
    mp_length		t, i;
    mp_base_type	b;
    mp_sign_type	sign;


    DEBUG_BEGIN(DEBUG_OTHER);
    DEBUG_PRINTF_1("+int_to_mp {\n");
    DEBUG_PRINTF_2("ix = %d\n", ix);

    if (!ix)
    {
	mp_set_sign(zp, 0);

	DEBUG_PRINTF_1("-} z = 0\n");
	DEBUG_END();

	return z;
    }


    t = mp_t(zp);
    b = mp_b(zp);

    /*
    Set ix to int_abs(ix).
    */

    if (ix < 0)
    {
	sign = -1;
	ix = -ix;
    }
    else 
	sign = 1;


    /*
    Optimization:  Since ix is nearly always a very small integer,
    we can place ix in the first digit and zero the rest if ix is less than
    the base.  Otherwise we start at the last digit and work to the left.
    */

    if (ix < b)
    {
	mp_set_digit(zp, 0, ix);
	mp_set_digits_zero(mp_digit_ptr(zp, 1), t - 1);

	mp_set_sign(zp, sign);
	mp_expt(zp) = 1;

	DEBUG_1("-} z = ", zp);
	DEBUG_END();

	return z;
    }


    /*
    Place ix in digits starting from end - leading digits will be cleared.
    */

    for (i = t - 1; i >= 0; i--)
    {
	mp_set_digit(zp, i, ix % b);
	ix /= b;
    }

    if (ix)
	mp_error("mp_int_to_mp: ix too big to fit in z");


    /*
    Copy sign of ix and set exponent to t when calling mp_nzr().
    */

    mp_nzr(sign, t, zp, mp_digit_ptr(zp, 0), 0);


    DEBUG_1("-} z = ", zp);
    DEBUG_END();

    return z;
}
