#include "defs.h"
#include "mp.e"
#include "mp.h"
 
#ifdef MP_USE_RECALL
mp_float        mp_pi_precise_val;
mp_int          mp_pi_precise_len;
#endif MP_USE_RECALL
 
mp_float mp_pi WITH_1_ARG(mp_float, x)
/*
Sets x = pi to the available precision.  The function uses Machin's identity:
 
        pi/4 = 4 * arctan(1/5) - arctan(1/239).
 
Accumulator operations are performed.
*/
{
    mp_base_type        b = mp_b(mp_ptr(x));
    mp_length           t = mp_t(mp_ptr(x));
    mp_acc_float        temp1, temp2;
 
#ifdef MP_USE_RECALL
    if (mp_pi_precise_len >= 0)
    {
        if (mp_pi_precise_len >= t)
        {
            /*
            ** Return imprecise copy of recalled value of pi.
            */
 
            mp_priv_move(mp_pi_precise_val, x);
            return x;
        }
 
        /*
        ** Delete copy of pi, needed to greater accuracy.
        */
 
        mp_delete_float(mp_pi_precise_val);
    }
 
    /*
    ** Can assume that no precise value is remembered at this moment in
    ** time. (Re)calculate pi and store result in mp_pi_precise_val.
    */
 
    mp_pi_precise_val = mp_alloc(b, t);
    mp_pi_precise_len = t;
#endif MP_USE_RECALL
 
    if (round == MP_TRUNC && b > 100)
    {
        /*
        No guard digits are necessary.
        */
 
        mp_acc_float_alloc(b, t, temp1);
 
        mp_atn1(5, temp1);
        mp_mul_int_eq(temp1, 4);
 
        mp_atn1(239, x);
        mp_sub(temp1, x, x);
 
        /*
        Use rounded multiplication by 4.
        */
 
        round = MP_RND;
        mp_mul_int_eq(x, 4);
        round = MP_TRUNC;
    }
 
    else
    {
        /*
        Add some extra guard digits.
        */
 
        mp_round_type   save_round = round;
 
 
        t += mp_guard_digits(100, b);
 
        mp_acc_float_alloc_2(b, t, temp1, temp2);
 
        mp_atn1(5, temp1);
        mp_mul_int_eq(temp1, 4);
 
        /*
        Take care if directed rounding is required.
        */
 
        round = mp_fix_directed(-1, round);
 
        mp_atn1(239, temp2);
 
        round = save_round;
 
        mp_sub(temp1, temp2, temp2);
        mp_mul_int_eq(temp2, 4);
 
        mp_move(temp2, x);
        mp_acc_float_delete(temp2);
    }
 
    mp_acc_float_delete(temp1);
 
#ifdef MP_USE_RECALL
    /*
    ** Record value for later recall.
    */
 
    mp_copy(x, mp_pi_precise_val);
#endif MP_USE_RECALL
 
    return x;
}
 
