#include "defs.h"
#include "poly.h"

t_poly
poly_add(pring, apoly, bpoly)
t_handle	pring;
t_poly	apoly, bpoly;
{
	t_poly_context	context;
	
	poly_init_context(pring, &context);
	return poly_add_crf(&context, apoly, bpoly);
}


t_poly
poly_add_crf(context, apoly, bpoly)
t_poly_ctx	context;
t_poly	apoly, bpoly;
{
	t_pfh		elt_add;
	t_handle	cring;
	t_handle         resph;        /* handle to respoly          */
	t_int    anterms;      /* no. terms in apoly         */
	t_int    bnterms;      /* no. terms in bpoly         */
	t_int    resnterms;    /* max. no. terms in respoly  */
	t_int    restermno;    /* term counter for respoly   */
	t_int    atermno;      /* term counter for apoly     */
	t_int    btermno;      /* term counter for bpoly     */
	t_poly        acoefft;      /* coefficient variables      */
	t_poly        bcoefft;
	t_int    aexpt;        /* exponent variables         */
	t_int    bexpt;
	t_poly        temp;         /* swaps                      */
	t_polyp		ap, bp;
	t_polyp		resp;
	t_int		univ;

	DENY(m_poly_const (apoly) || m_poly_const (bpoly));

	elt_add = m_poly_ctx_elt_add(context);
	cring = m_poly_ctx_cring(context);

	ap = m_poly_to_ptr( apoly );
	bp = m_poly_to_ptr( bpoly );

	anterms = m_polyp_nterms( ap );
	bnterms = m_polyp_nterms( bp );
	resnterms = anterms + bnterms;
	atermno = btermno = restermno = 0;
	m_poly_create_empty(&resph,m_polyp_princvar(ap),
		m_polyp_least_pvar(ap),resnterms);
	resp = m_poly_hdl_to_ptr(resph);
	univ = m_polyp_univariate(ap);

	while ( ( atermno < anterms ) && ( btermno < bnterms ) ) 
	{
		aexpt = m_polyp_expt( ap, atermno );
		bexpt = m_polyp_expt( bp, btermno );

		if ( aexpt < bexpt )
		{
		    polyp_copy_term_crf(context,resp,restermno,ap,atermno);
		    restermno++;
		    atermno++;
		}
		else if ( aexpt > bexpt )
		{
		    polyp_copy_term_crf(context,resp,restermno,bp,btermno);
		    restermno++;
		    btermno++;
		}
		else
		{
		    /* aexpt == bexpt */

		    acoefft = m_polyp_coefft( ap, atermno );
		    bcoefft = m_polyp_coefft( bp, btermno );

		    if (univ)
		    {
			(*elt_add)(cring, acoefft, bcoefft, &temp);
		    }
		    else
		    {
			temp = poly_add_crf( context, acoefft, bcoefft );
		    }

		    m_polyp_coefft( resp, restermno ) = temp;
		    m_polyp_expt( resp, restermno ) = aexpt;
		    restermno++;
		    atermno++;
		    btermno++;
		}
	}

	/* copy rest of apoly */

	for ( ; atermno < anterms; atermno++, restermno++ )
	{
		polyp_copy_term_crf( context, resp, restermno, ap, atermno );
	}

	/* copy rest of bpoly */

	for ( ;btermno < bnterms; btermno++, restermno++ )
	{
		polyp_copy_term_crf( context, resp, restermno, bp, btermno );
	}

	m_polyp_nterms( resp ) = restermno;
	return  poly_clean_crf (context, m_poly_handle_to_poly( resph )); 

} /* poly_add_crf */

